/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.MetadataRestClient;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.SessionRestClient;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.ServerInfo;
import com.atlassian.jira.rest.client.domain.Session;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.Votes;
import com.atlassian.jira.rest.client.domain.Watchers;
import com.atlassian.jira.rest.client.domain.input.AttachmentInput;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.domain.input.LinkIssuesInput;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParser;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParserV5;
import com.atlassian.jira.rest.client.internal.json.VotesJsonParser;
import com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import com.atlassian.jira.rest.client.internal.json.gen.CommentJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.LinkIssuesInputGenerator;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.MultiPartMediaTypes;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JerseyIssueRestClient
extends AbstractJerseyRestClient
implements IssueRestClient {
    private static final String FILE_ATTACHMENT_CONTROL_NAME = "file";
    private final SessionRestClient sessionRestClient;
    private final MetadataRestClient metadataRestClient;
    private final IssueJsonParser issueParser = new IssueJsonParser();
    private final JsonParser<Watchers> watchersParser = WatchersJsonParserBuilder.createWatchersParser();
    private final TransitionJsonParser transitionJsonParser = new TransitionJsonParser();
    private final JsonParser<Transition> transitionJsonParserV5 = new TransitionJsonParserV5();
    private final VotesJsonParser votesJsonParser = new VotesJsonParser();
    private ServerInfo serverInfo;

    public JerseyIssueRestClient(URI baseUri, ApacheHttpClient client, SessionRestClient sessionRestClient, MetadataRestClient metadataRestClient) {
        super(baseUri, client);
        this.sessionRestClient = sessionRestClient;
        this.metadataRestClient = metadataRestClient;
    }

    private synchronized ServerInfo getVersionInfo(ProgressMonitor progressMonitor) {
        if (this.serverInfo == null) {
            this.serverInfo = this.metadataRestClient.getServerInfo(progressMonitor);
        }
        return this.serverInfo;
    }

    @Override
    public Watchers getWatchers(URI watchersUri, ProgressMonitor progressMonitor) {
        return this.getAndParse(watchersUri, this.watchersParser, progressMonitor);
    }

    @Override
    public Votes getVotes(URI votesUri, ProgressMonitor progressMonitor) {
        return this.getAndParse(votesUri, this.votesJsonParser, progressMonitor);
    }

    @Override
    public Issue getIssue(String issueKey, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri);
        uriBuilder.path("issue").path(issueKey).queryParam("expand", new Object[]{"names,schema,transitions"});
        return this.getAndParse(uriBuilder.build(new Object[0]), this.issueParser, progressMonitor);
    }

    @Override
    public Iterable<Transition> getTransitions(final URI transitionsUri, ProgressMonitor progressMonitor) {
        return this.invoke(new Callable<Iterable<Transition>>(){

            @Override
            public Iterable<Transition> call() throws Exception {
                WebResource transitionsResource = JerseyIssueRestClient.this.client.resource(transitionsUri);
                JSONObject jsonObject = (JSONObject)transitionsResource.get(JSONObject.class);
                if (jsonObject.has("transitions")) {
                    JSONArray transitionsArray = jsonObject.getJSONArray("transitions");
                    ArrayList<Transition> transitions = new ArrayList<Transition>(transitionsArray.length());
                    int s = transitionsArray.length();
                    for (int i = 0; i < s; ++i) {
                        try {
                            Transition transition = (Transition)JerseyIssueRestClient.this.transitionJsonParserV5.parse(transitionsArray.getJSONObject(i));
                            transitions.add(transition);
                            continue;
                        }
                        catch (JSONException e) {
                            throw new RestClientException(e);
                        }
                    }
                    return transitions;
                }
                ArrayList<Transition> transitions = new ArrayList<Transition>(jsonObject.length());
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    try {
                        int id = Integer.parseInt(key);
                        Transition transition = JerseyIssueRestClient.this.transitionJsonParser.parse(jsonObject.getJSONObject(key), id);
                        transitions.add(transition);
                    }
                    catch (JSONException e) {
                        throw new RestClientException(e);
                    }
                    catch (NumberFormatException e) {
                        throw new RestClientException("Transition id should be an integer, but found [" + key + "]", (Throwable)e);
                    }
                }
                return transitions;
            }
        });
    }

    @Override
    public Iterable<Transition> getTransitions(Issue issue, ProgressMonitor progressMonitor) {
        if (issue.getTransitionsUri() != null) {
            return this.getTransitions(issue.getTransitionsUri(), progressMonitor);
        }
        UriBuilder transitionsUri = UriBuilder.fromUri((URI)issue.getSelf());
        return this.getTransitions(transitionsUri.path("transitions").queryParam("expand", new Object[]{"transitions.fields"}).build(new Object[0]), progressMonitor);
    }

    @Override
    public void transition(final URI transitionsUri, final TransitionInput transitionInput, final ProgressMonitor progressMonitor) {
        final int buildNumber = this.getVersionInfo(progressMonitor).getBuildNumber();
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JSONObject jsonObject = new JSONObject();
                if (buildNumber >= 700) {
                    jsonObject.put("transition", (Object)new JSONObject().put("id", transitionInput.getId()));
                } else {
                    jsonObject.put("transition", transitionInput.getId());
                }
                if (transitionInput.getComment() != null) {
                    if (buildNumber >= 700) {
                        jsonObject.put("update", (Object)new JSONObject().put("comment", (Object)new JSONArray().put((Object)new JSONObject().put("add", (Object)new CommentJsonGenerator(JerseyIssueRestClient.this.getVersionInfo(progressMonitor), "group").generate(transitionInput.getComment())))));
                    } else {
                        jsonObject.put("comment", (Object)new CommentJsonGenerator(JerseyIssueRestClient.this.getVersionInfo(progressMonitor), "group").generate(transitionInput.getComment()));
                    }
                }
                JSONObject fieldsJs = new JSONObject();
                Iterable<FieldInput> fields = transitionInput.getFields();
                if (fields.iterator().hasNext()) {
                    for (FieldInput fieldInput : fields) {
                        fieldsJs.put(fieldInput.getId(), fieldInput.getValue());
                    }
                }
                if (fieldsJs.keys().hasNext()) {
                    jsonObject.put("fields", (Object)fieldsJs);
                }
                WebResource issueResource = JerseyIssueRestClient.this.client.resource(transitionsUri);
                issueResource.post((Object)jsonObject);
                return null;
            }
        });
    }

    @Override
    public void transition(Issue issue, TransitionInput transitionInput, ProgressMonitor progressMonitor) {
        if (issue.getTransitionsUri() != null) {
            this.transition(issue.getTransitionsUri(), transitionInput, progressMonitor);
        } else {
            UriBuilder uriBuilder = UriBuilder.fromUri((URI)issue.getSelf());
            uriBuilder.path("transitions");
            this.transition(uriBuilder.build(new Object[0]), transitionInput, progressMonitor);
        }
    }

    @Override
    public void vote(final URI votesUri, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource votesResource = JerseyIssueRestClient.this.client.resource(votesUri);
                votesResource.post();
                return null;
            }
        });
    }

    @Override
    public void unvote(final URI votesUri, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource votesResource = JerseyIssueRestClient.this.client.resource(votesUri);
                votesResource.delete();
                return null;
            }
        });
    }

    @Override
    public void addWatcher(final URI watchersUri, final @Nullable String username, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource.Builder builder = JerseyIssueRestClient.this.client.resource(watchersUri).type(MediaType.APPLICATION_JSON_TYPE);
                if (username != null) {
                    builder.post((Object)JSONObject.quote((String)username));
                } else {
                    builder.post();
                }
                return null;
            }
        });
    }

    private String getLoggedUsername(ProgressMonitor progressMonitor) {
        Session session = this.sessionRestClient.getCurrentSession(progressMonitor);
        return session.getUsername();
    }

    @Override
    public void removeWatcher(URI watchersUri, String username, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)watchersUri);
        if (this.getVersionInfo(progressMonitor).getBuildNumber() >= 640) {
            uriBuilder.queryParam("username", new Object[]{username});
        } else {
            uriBuilder.path(username).build(new Object[0]);
        }
        this.delete(uriBuilder.build(new Object[0]), progressMonitor);
    }

    @Override
    public void linkIssue(final LinkIssuesInput linkIssuesInput, final ProgressMonitor progressMonitor) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("issueLink").build(new Object[0]);
        this.post(uri, new Callable<JSONObject>(){

            @Override
            public JSONObject call() throws Exception {
                return new LinkIssuesInputGenerator(JerseyIssueRestClient.this.getVersionInfo(progressMonitor)).generate(linkIssuesInput);
            }
        }, progressMonitor);
    }

    @Override
    public void addAttachment(ProgressMonitor progressMonitor, URI attachmentsUri, InputStream in, String filename) {
        this.addAttachments(progressMonitor, attachmentsUri, new AttachmentInput(filename, in));
    }

    @Override
    public void addAttachments(ProgressMonitor progressMonitor, final URI attachmentsUri, AttachmentInput ... attachments) {
        final ArrayList myAttachments = Lists.newArrayList((Object[])attachments);
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MultiPart multiPartInput = new MultiPart();
                for (AttachmentInput attachment : myAttachments) {
                    BodyPart bp = new BodyPart((Object)attachment.getInputStream(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
                    FormDataContentDisposition.FormDataContentDispositionBuilder dispositionBuilder = FormDataContentDisposition.name((String)JerseyIssueRestClient.FILE_ATTACHMENT_CONTROL_NAME);
                    dispositionBuilder.fileName(attachment.getFilename());
                    FormDataContentDisposition formDataContentDisposition = dispositionBuilder.build();
                    bp.setContentDisposition((ContentDisposition)formDataContentDisposition);
                    multiPartInput.bodyPart(bp);
                }
                JerseyIssueRestClient.this.postFileMultiPart(multiPartInput, attachmentsUri);
                return null;
            }
        });
    }

    @Override
    public InputStream getAttachment(ProgressMonitor pm, final URI attachmentUri) {
        return this.invoke(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                WebResource attachmentResource = JerseyIssueRestClient.this.client.resource(attachmentUri);
                return (InputStream)attachmentResource.get(InputStream.class);
            }
        });
    }

    @Override
    public void addAttachments(ProgressMonitor progressMonitor, final URI attachmentsUri, File ... files) {
        final ArrayList myFiles = Lists.newArrayList((Object[])files);
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MultiPart multiPartInput = new MultiPart();
                for (File file : myFiles) {
                    FileDataBodyPart fileDataBodyPart = new FileDataBodyPart(JerseyIssueRestClient.FILE_ATTACHMENT_CONTROL_NAME, file);
                    multiPartInput.bodyPart((BodyPart)fileDataBodyPart);
                }
                JerseyIssueRestClient.this.postFileMultiPart(multiPartInput, attachmentsUri);
                return null;
            }
        });
    }

    private void postFileMultiPart(MultiPart multiPartInput, URI attachmentsUri) {
        WebResource attachmentsResource = this.client.resource(attachmentsUri);
        WebResource.Builder builder = attachmentsResource.type(MultiPartMediaTypes.createFormData());
        builder.header("X-Atlassian-Token", (Object)"nocheck");
        builder.post((Object)multiPartInput);
    }

    @Override
    public void watch(URI watchersUri, ProgressMonitor progressMonitor) {
        this.addWatcher(watchersUri, null, progressMonitor);
    }

    @Override
    public void unwatch(URI watchersUri, ProgressMonitor progressMonitor) {
        this.removeWatcher(watchersUri, this.getLoggedUsername(progressMonitor), progressMonitor);
    }
}

