package com.atlassian.integrationtesting.ui;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;

import be.roam.hue.doj.Doj;

public interface UiTester
{
    /**
     * Returns the currently logged in user, {@code null} if there is no logged-in user 
     */
    String getLoggedInUser();

    /**
     * Returns {@code true} if the current page is the applications log in page, {@code false} otherwise.
     * 
     * @return {@code true} if the current page is the applications log in page, {@code false} otherwise.
     */
    boolean isOnLoginPage();

    void destroy();

    /**
     * Returns the base url from the Application Properties
     * @return the base url from the Application Properties
     */
    String getBaseUrl();

    /**
     * Logs in to the UPM page under test as the specified user. The password used will be the same as the username
     *
     * @param username the user to log in as
     * @throws IllegalStateException if a login session is already active
     */
    void logInAs(String username);

    /**
     * Logs out the user from the UPM page under test.
     *
     * @throws IllegalStateException if no login session is active
     */
    void logout();

    /**
     * Sets the {@code currentPage} to the page specified by {@code relativePath}, and returns it
     *
     * @param relativePath the relative path to redirect the page to
     * @return the current page
     */
    HtmlPage gotoPage(String relativePath);

    /**
     * Refresh the {@code currentPage} by sending the same parameters as previously sent to get this page.
     * @return the newly loaded page.
     * @throws RuntimeException if an IO problem occurs
     */
    Page refreshPage();

    /**
     * Returns the {@code class} attribute of the element with ID = {@code elementId}
     * @param elementId the ID of the element
     * @return the {@code class} attribute of the element with ID = {@code elementId}
     */
    String getStyleClass(String elementId);

    void clickElementWithId(String id);

    int waitForAsyncEventsToComplete();

    /**
     * <p>This method blocks until all background JavaScript tasks have finished executing. Background
     * JavaScript tasks are JavaScript tasks scheduled for execution via <tt>window.setTimeout</tt>,
     * <tt>window.setInterval</tt> or asynchronous <tt>XMLHttpRequest</tt>.</p>
     *
     * <p>If a job is scheduled to begin executing after <tt>(now + timeoutMillis)</tt>, this method will
     * wait for <tt>timeoutMillis</tt> milliseconds and then return a value greater than <tt>0</tt>. This
     * method will never block longer than <tt>timeoutMillis</tt> milliseconds.</p>
     *
     * <p>Use this method instead of {@link #waitForAsyncEventsToCompleteStartingBefore(long)} if you
     * don't know when your background JavaScript is supposed to start executing, but you're fairly sure
     * that you know how long it should take to finish executing.</p>
     *
     * @param timeoutMillis the maximum amount of time to wait (in milliseconds)
     * @return the number of background JavaScript jobs still executing or waiting to be executed when this
     *         method returns; will be <tt>0</tt> if there are no jobs left to execute
     */
    int waitForAsyncEventsToComplete(long timeoutMillis);

    int waitForAsyncEventsThatBeginWithinDefaultTime();

    /**
     * <p>This method blocks until all background JavaScript tasks scheduled to start executing before
     * <tt>(now + delayMillis)</tt> have finished executing. Background JavaScript tasks are JavaScript
     * tasks scheduled for execution via <tt>window.setTimeout</tt>, <tt>window.setInterval</tt> or
     * asynchronous <tt>XMLHttpRequest</tt>.</p>
     *
     * <p>If there is no background JavaScript task currently executing, and there is no background JavaScript
     * task scheduled to start executing within the specified time, this method returns immediately -- even
     * if there are tasks scheduled to be executed after <tt>(now + delayMillis)</tt>.</p>
     *
     * <p>Note that the total time spent executing a background JavaScript task is never known ahead of
     * time, so this method makes no guarantees as to how long it will block.</p>
     *
     * <p>Use this method instead of {@link #waitForAsyncEventsToComplete(long)} if you know roughly when
     * your background JavaScript is supposed to start executing, but you're not necessarily sure how long
     * it will take to execute.</p>
     *
     * @param delayMillis the delay which determines the background tasks to wait for (in milliseconds)
     * @return the number of background JavaScript jobs still executing or waiting to be executed when this
     *         method returns; will be <tt>0</tt> if there are no jobs left to execute
     */
    int waitForAsyncEventsThatBeginWithin(long delayMillis);

    HtmlElement getElementById(String id);

    Doj currentPage();

    /**
     * Get the current Html contents in a formatted String form.
     * @return the current Html contents in a formatted String form.
     */
    String getHtmlContents();

    Doj elementById(String id);

    void closeWindows();

    /**
     * Restore the data from the backup file using the applications data restore feature.
     * 
     * @param backup file that was exported from the application
     * @param user user to restore the file as
     */
    void restore(String backup);

    void restore(String backup, String user);

    boolean isJavaScriptEnabled();

    void setJavaScriptEnabled(boolean enabled);
}
