package com.atlassian.integrationtesting.ui;

import com.atlassian.integrationtesting.ui.CompositeUiTester.Backup;
import com.atlassian.integrationtesting.ui.CompositeUiTester.Login;
import com.atlassian.integrationtesting.ui.CompositeUiTester.WebSudoLogin;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;

import static com.atlassian.integrationtesting.ui.UiTesters.doNothingWebSudoLogin;
import static com.atlassian.integrationtesting.ui.UiTesters.goToPageToLogout;
import static com.atlassian.integrationtesting.ui.UiTesters.logInByGoingTo;
import static com.atlassian.integrationtesting.ui.UiTesters.restoreUnsupported;

/**
 * {@code UiTesterProvider}s for FeCru versions 2.2 and 2.3.
 */
public enum FeCru implements UiTesterFunctionProvider
{
    v2_2,
    v2_3;
    
    private final Function<UiTester, Void> logout = goToPageToLogout("logout");
    public Function<UiTester, Void> logout()
    {
        return logout;
    }

    public Function<WebSudoLogin, HtmlPage> webSudoLogIn()
    {
        return doNothingWebSudoLogin();
    }

    private final Function<Login, HtmlPage> logIn = logInByGoingTo("login").formName("loginform").userInputName("username").passwordInputName("password").submitButtonId("submit").build();
    public Function<Login, HtmlPage> logIn()
    {
        return logIn;
    }

    public Function<UiTester, String> getLoggedInUser()
    {
        return UiTesters.getLoggedInUser();
    }

    public Function<UiTester, Boolean> isOnLogInPage()
    {
        return IsOnLogInPage.INSTANCE;
    }

    private enum IsOnLogInPage implements Function<UiTester, Boolean>
    {
        INSTANCE;

        public Boolean apply(UiTester uiTester)
        {
            return uiTester.currentPage().getByTag("title").trimmedText().startsWith("Log in");
        }
    }

    public Function<Backup, Void> restore()
    {
        return restoreUnsupported("Fisheye does not support online data restores.");
    }
}
