package com.atlassian.integrationtesting.runner.restore;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>Specify the backup file that will be imported into the application.  If specified at the class level, the data will
 * be imported before each test method is run.  If specified at the method level, the data will be imported before that
 * particular test method is run.  If this annotation appears on the class and the test method, the annotation on
 * the test method will override the annotation on the class.</p>
 * 
 * <p>If this annotation appears on a test method inside a class annotated with {@link RestoreOnce}, then this data is
 * imported before the test method is run.  After the test method finishes, the backup file specified by
 * {@code RestoreOnce} is re-imported.</p>
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface Restore
{
    String value();
    
    String user() default "admin";
}
