/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.integration.jira.element.internal.OAuthConfirmPage;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public abstract class JiraDialog {
    protected final By locator;
    @Inject
    protected WebDriver driver;
    @Inject
    protected PageBinder pageBinder;
    protected PageElement root;
    @Inject
    protected PageElementFinder elementFinder;

    public JiraDialog(By locator) {
        this.locator = locator;
    }

    public JiraDialog completeOAuthDance(String jiraUsername, String jiraPassword) {
        this.waitUntilAuthenticationMessageShown();
        String currentWindowHandle = this.driver.getWindowHandle();
        this.root.find(By.className((String)"applink-authenticate"), TimeoutType.AJAX_ACTION).click();
        return (JiraDialog)((OAuthConfirmPage)this.pageBinder.bind(OAuthConfirmPage.class, new Object[]{this})).confirmHandlingWebLoginIfRequired(currentWindowHandle, jiraUsername, jiraPassword);
    }

    public void waitUntilAuthenticationMessageShown() {
        Poller.waitUntilTrue((TimedQuery)this.root.find(By.className((String)"applink-authenticate"), TimeoutType.AJAX_ACTION).timed().isVisible());
    }

    public TimedCondition isOpen() {
        return this.root.find(By.className((String)"dialog-components"), TimeoutType.DIALOG_LOAD).timed().isVisible();
    }

    public void waitUntilErrorsShown() {
        Poller.waitUntilTrue((TimedQuery)this.root.find(By.className((String)"jira-dialog-message"), TimeoutType.AJAX_ACTION).timed().isVisible());
    }

    public void close() {
        this.waitUntilOpen();
        this.root.find(this.getCancelButtonLocator()).click();
        this.waitUntilClosed();
    }

    protected abstract By getCancelButtonLocator();

    protected void waitUntilClosed() {
        Poller.waitUntilFalse((TimedQuery)this.isOpen());
    }

    @WaitUntil
    protected void waitUntilOpen() {
        this.initRoot();
        Poller.waitUntilTrue((TimedQuery)this.isOpen());
    }

    @Init
    private void initRoot() {
        if (this.root == null) {
            this.root = this.elementFinder.find(this.locator);
        }
    }
}

