/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.httpclient.api.BaseResponsePromise;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponsePromiseTransformationBuilder;
import com.atlassian.httpclient.api.UnexpectedResponseException;
import com.atlassian.httpclient.api.WrappingBaseResponsePromise;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promises;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Set;

final class WrappingResponsePromise
extends WrappingBaseResponsePromise<Response>
implements ResponsePromise {
    public WrappingResponsePromise(ListenableFuture<Response> delegate) {
        super(Promises.forListenableFuture(delegate));
    }

    @Override
    public <T> ResponsePromiseTransformationBuilder<T> transform() {
        return new ResponsePromiseTransformationBuilder(this);
    }

    @Override
    public BaseResponsePromise<Response> otherwise(final Effect<Throwable> callback) {
        this.others(new Effect<Response>(){

            public void apply(Response response) {
                callback.apply((Object)new UnexpectedResponseException(response));
            }
        });
        this.fail((Effect)callback);
        return this;
    }

    @Override
    protected Effect<Response> newStatusSelector(int statusCode, Effect<Response> callback) {
        return new StatusSelector(statusCode, callback);
    }

    @Override
    protected Effect<Response> newStatusSetSelector(WrappingBaseResponsePromise.StatusSet statusSet, Effect<Response> callback) {
        return new StatusSetSelector(statusSet, callback);
    }

    @Override
    protected Effect<Response> newOthersSelector(Set<Integer> statuses, Set<WrappingBaseResponsePromise.StatusSet> statusSets, Effect<Response> callback) {
        return new OthersSelector(statuses, statusSets, callback);
    }

    private static class OthersSelector
    implements Effect<Response> {
        private final Effect<Response> callback;
        private final Set<Integer> statuses;
        private final Set<WrappingBaseResponsePromise.StatusSet> statusSets;

        private OthersSelector(Set<Integer> statuses, Set<WrappingBaseResponsePromise.StatusSet> statusSets, Effect<Response> callback) {
            this.statuses = new HashSet<Integer>(statuses);
            this.statusSets = new HashSet<WrappingBaseResponsePromise.StatusSet>(statusSets);
            this.callback = callback;
        }

        public void apply(Response response) {
            int status = response.getStatusCode();
            boolean inStatusSets = false;
            for (WrappingBaseResponsePromise.StatusSet statusSet : this.statusSets) {
                if (!statusSet.contains(status)) continue;
                inStatusSets = true;
                break;
            }
            if (!inStatusSets && !this.statuses.contains(status)) {
                this.callback.apply((Object)response);
            }
        }
    }

    private static class StatusSetSelector
    implements Effect<Response> {
        private WrappingBaseResponsePromise.StatusSet statusSet;
        private final Effect<Response> callback;

        private StatusSetSelector(WrappingBaseResponsePromise.StatusSet statusSet, Effect<Response> callback) {
            this.statusSet = statusSet;
            this.callback = callback;
        }

        public void apply(Response response) {
            if (this.statusSet.contains(response.getStatusCode())) {
                this.callback.apply((Object)response);
            }
        }
    }

    private static class StatusSelector
    implements Effect<Response> {
        private final int statusCode;
        private final Effect<Response> callback;

        private StatusSelector(int statusCode, Effect<Response> callback) {
            this.statusCode = statusCode;
            this.callback = callback;
        }

        public void apply(Response response) {
            if (response.getStatusCode() == this.statusCode) {
                this.callback.apply((Object)response);
            }
        }
    }
}

