/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.httpclient.api.BaseResponsePromise;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsesPromise;
import com.atlassian.httpclient.api.UnexpectedResponsesException;
import com.atlassian.httpclient.api.WrappingBaseResponsePromise;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promises;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class WrappingResponsesPromise
extends WrappingBaseResponsePromise<List<Response>>
implements ResponsesPromise {
    public WrappingResponsesPromise(ListenableFuture<List<Response>> delegate) {
        super(Promises.forListenableFuture(delegate));
    }

    @Override
    public BaseResponsePromise<List<Response>> otherwise(final Effect<Throwable> callback) {
        this.others(new Effect<List<Response>>(){

            public void apply(List<Response> responses) {
                callback.apply((Object)new UnexpectedResponsesException(responses));
            }
        });
        this.fail((Effect)callback);
        return this;
    }

    @Override
    protected Effect<List<Response>> newStatusSelector(int statusCode, Effect<List<Response>> callback) {
        return new StatusSelector(statusCode, callback);
    }

    @Override
    protected Effect<List<Response>> newStatusSetSelector(WrappingBaseResponsePromise.StatusSet statusSet, Effect<List<Response>> callback) {
        return new StatusSetSelector(statusSet, callback);
    }

    @Override
    protected Effect<List<Response>> newOthersSelector(Set<Integer> statuses, Set<WrappingBaseResponsePromise.StatusSet> statusSets, Effect<List<Response>> callback) {
        return new OthersSelector(statuses, statusSets, callback);
    }

    private static class OthersSelector
    implements Effect<List<Response>> {
        private final Effect<List<Response>> callback;
        private final Set<Integer> statuses;
        private final Set<WrappingBaseResponsePromise.StatusSet> statusSets;

        private OthersSelector(Set<Integer> statuses, Set<WrappingBaseResponsePromise.StatusSet> statusSets, Effect<List<Response>> callback) {
            this.statuses = new HashSet<Integer>(statuses);
            this.statusSets = new HashSet<WrappingBaseResponsePromise.StatusSet>(statusSets);
            this.callback = callback;
        }

        public void apply(List<Response> responses) {
            boolean noneMatch = true;
            for (WrappingBaseResponsePromise.StatusSet statusSet : this.statusSets) {
                if (!this.containsAll(statusSet, responses)) continue;
                noneMatch = false;
                break;
            }
            if (noneMatch) {
                Iterator<Object> i$ = this.statuses.iterator();
                while (i$.hasNext()) {
                    int status = (Integer)i$.next();
                    if (!this.matchesAll(status, responses)) continue;
                    noneMatch = false;
                    break;
                }
                if (noneMatch) {
                    this.callback.apply(responses);
                }
            }
        }

        private boolean containsAll(WrappingBaseResponsePromise.StatusSet statusSet, List<Response> responses) {
            boolean result = true;
            for (Response response : responses) {
                if (statusSet.contains(response.getStatusCode())) continue;
                result = false;
                break;
            }
            return result;
        }

        private boolean matchesAll(int status, List<Response> responses) {
            boolean result = true;
            for (Response response : responses) {
                if (response.getStatusCode() == status) continue;
                result = false;
                break;
            }
            return result;
        }
    }

    private static class StatusSetSelector
    implements Effect<List<Response>> {
        private WrappingBaseResponsePromise.StatusSet statusSet;
        private final Effect<List<Response>> callback;

        private StatusSetSelector(WrappingBaseResponsePromise.StatusSet statusSet, Effect<List<Response>> callback) {
            this.statusSet = statusSet;
            this.callback = callback;
        }

        public void apply(List<Response> responses) {
            boolean allMatch = true;
            for (Response response : responses) {
                if (this.statusSet.contains(response.getStatusCode())) continue;
                allMatch = false;
                break;
            }
            if (allMatch) {
                this.callback.apply(responses);
            }
        }
    }

    private static class StatusSelector
    implements Effect<List<Response>> {
        private final int statusCode;
        private final Effect<List<Response>> callback;

        private StatusSelector(int statusCode, Effect<List<Response>> callback) {
            this.statusCode = statusCode;
            this.callback = callback;
        }

        public void apply(List<Response> responses) {
            boolean allMatch = true;
            for (Response response : responses) {
                if (response.getStatusCode() == this.statusCode) continue;
                allMatch = false;
                break;
            }
            if (allMatch) {
                this.callback.apply(responses);
            }
        }
    }
}

