/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.api;

import com.atlassian.fugue.Functions;
import com.atlassian.fugue.Option;
import com.atlassian.httpclient.api.MatchException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;

public class PartialFunctions {
    public static <A, B> Function<A, Option<B>> from(Predicate<A> p, Function<? super A, ? extends B> f) {
        return Functions.partial(p, f);
    }

    public static <A, B> Function<A, B> compose(Iterable<Function<A, Option<B>>> it) {
        return new Stack<A, B>(it);
    }

    static final class Partial<A, B>
    implements Function<A, Option<B>> {
        private final Predicate<A> p;
        private final Function<? super A, ? extends B> f;

        private Partial(Predicate<A> p, Function<? super A, ? extends B> f) {
            this.p = (Predicate)Preconditions.checkNotNull(p);
            this.f = (Function)Preconditions.checkNotNull(f);
        }

        public Option<B> apply(A a) {
            if (this.p.apply(a)) {
                return Option.option((Object)this.f.apply(a));
            }
            return Option.none();
        }
    }

    static class Stack<A, B>
    implements Function<A, B> {
        private final Iterable<Function<A, Option<B>>> partials;

        Stack(Iterable<Function<A, Option<B>>> partials) {
            this.partials = (Iterable)Preconditions.checkNotNull(partials);
        }

        public B apply(A a) {
            for (Function<A, Option<B>> f : this.partials) {
                Option option = (Option)f.apply(a);
                if (!option.isDefined()) continue;
                return (B)option.get();
            }
            throw new MatchException(a);
        }
    }
}

