package com.atlassian.extras.decoder.api;

import com.atlassian.extras.common.LicenseException;
import com.atlassian.extras.common.LicensePropertiesConstants;

import java.util.Properties;

/**
 * @since 2.2.1
 */
public abstract class AbstractLicenseDecoder implements LicenseDecoder {

    @Override
    public final Properties decode(final String licenseString) throws LicenseVerificationException {
        final Properties licenseProperties = doDecode(licenseString);
        if (licenseProperties == null) {
            throw new LicenseException("Invalid License - an error occurred when decoding the license");
        }
        licenseProperties.setProperty(LicensePropertiesConstants.LICENSE_VERSION, String.valueOf(getLicenseVersion()));
        return licenseProperties;
    }

    /**
     * Actually decodes the license
     *
     * @see #decode(String)
     */
    protected abstract Properties doDecode(final String licenseString);

    /**
     * The version of the decoder the license was decoded with.
     */
    protected abstract int getLicenseVersion();
}
