package com.atlassian.extras.api.bamboo;

import com.atlassian.extras.api.LicenseEditionAware;
import com.atlassian.extras.api.ProductLicense;

/**
 *
 */
public interface BambooLicense extends ProductLicense, LicenseEditionAware {
    /**
     * Retrieves the maximum number of remote agents allowed by this license.
     *
     * @return maximum number of remote agents allowed by this license.  -1 if unlimited
     */
    int getMaximumNumberOfRemoteAgents();

    /**
     * Retrieves the maximum number of local agents allowed by this license.
     *
     * @return maximum number of local agents allowed by this license.  -1 if unlimited
     */
    int getMaximumNumberOfLocalAgents();

    /**
     * Retrieves the maximum number of plans allowed by this license.
     *
     * @return maximum number of plans allowed by this license.  -1 if unlimited
     */
    int getMaximumNumberOfPlans();

    /**
     * @return true if an unlimited number of remote agents is allowed, otherwise false.
     */
    boolean isUnlimitedRemoteAgents();

    /**
     * @return true if an unlimited number oof local agents is allowed, otherwise false.
     */
    boolean isUnlimitedLocalAgents();

    /**
     * @return true if an unlimited number of plans can be created for this license, otherwise false
     */
    boolean isUnlimitedPlans();
}
