package com.atlassian.extras.api;

/**
 * Implementation can choose to cache decoded licenses in a cache.
 */
public interface LicenseManager {
    /**
     * Gets the correct license object given an encoded license string.
     *
     * @param licenseString the encoded license
     * @return a decoded {@link com.atlassian.extras.api.AtlassianLicense Atlassian license} object.
     * @throws LicenseException if there are any errors in handling the license.
     */
    AtlassianLicense getLicense(String licenseString);

    /**
     * Remove all current AtlassianLicense objects if they were stored.
     */
    void clear();
}
