package com.atlassian.extras.api;

import java.util.Collection;

/**
 * This represent a license as distributed by Atlassian. Typically such a license can contain
 * {@link ProductLicense licenses} for more than one product.
 */
public interface AtlassianLicense {
    /**
     * Retrieves all the {@link ProductLicense product licenses} associated with this {@link AtlassianLicense this license}.
     *
     * @return the collection of product licenses.
     * @since 2.2.0
     */
    Collection<ProductLicense> getProductLicenses();

    /**
     * Retrieves the license for a given product.
     *
     * @param product the license corresponding to the given {@link Product}
     * @return the {@link ProductLicense} for the given {@code product}, {@code null} if not license was found
     * for this product
     */
    ProductLicense getProductLicense(Product product);
}
