package com.atlassian.diagnostics;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.time.Instant;

public interface AlertBuilder {

    /**
     * Builds the alert
     *
     * @return the alert
     */
    @Nonnull
    Alert build();

    /**
     * @param details alert details
     * @return the builder
     */
    @Nonnull
    AlertBuilder details(@Nullable Object details);

    /**
     * @param json JSON representation of the alert details
     * @return the builder
     */
    @Nonnull
    AlertBuilder detailsAsJson(@Nullable String json);

    /**
     * @param timestamp the alert timestamp
     * @return the builder
     */
    @Nonnull
    AlertBuilder timestamp(@Nonnull Instant timestamp);

    /**
     * @param trigger the alert trigger
     * @return the builder
     */
    @Nonnull
    AlertBuilder trigger(@Nullable AlertTrigger trigger);
}