package com.atlassian.db.config.password.ciphers.algorithm.paramters;

public class DecryptionParameters {
    private final String sealedObjectFilePath;
    private final String keyFilePath;
    private final String serializedSealedObject;

    public DecryptionParameters(final String sealedObjectFilePath, final String keyFilePath, final String serializedSealedObject) {
        this.sealedObjectFilePath = sealedObjectFilePath;
        this.keyFilePath = keyFilePath;
        this.serializedSealedObject = serializedSealedObject;
    }

    public String getSealedObjectFilePath() {
        return sealedObjectFilePath;
    }

    public String getKeyFilePath() {
        return keyFilePath;
    }

    public String getSerializedSealedObject() {
        return serializedSealedObject;
    }

    public static class Builder {

        private String sealedObjectFilePath;
        private String keyFilePath;
        private String serializedSealedObject;

        public Builder setSealedObjectFilePath(final String sealedObjectFilePath) {
            this.sealedObjectFilePath = sealedObjectFilePath;
            return this;
        }

        public Builder setKeyFilePath(final String keyFilePath) {
            this.keyFilePath = keyFilePath;
            return this;
        }

        public Builder serializedSealedObject(final String serializedSealedObject) {
            this.serializedSealedObject = serializedSealedObject;
            return this;
        }

        public DecryptionParameters build() {
            return new DecryptionParameters(sealedObjectFilePath, keyFilePath, serializedSealedObject);
        }
    }

    @Override
    public String toString() {
        return "DecryptionParameters{" +
                "sealedObjectFilePath='" + sealedObjectFilePath + '\'' +
                ", keyFilePath='" + keyFilePath + '\'' +
                ", serializedSealedObject='" + serializedSealedObject + '\'' +
                '}';
    }
}
