/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.db.config.password.ciphers.base64;

import com.atlassian.db.config.password.Cipher;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Cipher
implements Cipher {
    private static final Logger log = LoggerFactory.getLogger(Base64Cipher.class);

    public Base64Cipher() {
        log.debug("Initiate Base64Cipher");
    }

    public String encrypt(String plainTextData) {
        log.debug("Encrypting data...");
        try {
            String processed = this.encodeToString(plainTextData.getBytes());
            log.debug("Encryption done.");
            return processed;
        }
        catch (Exception runtimeException) {
            log.error("Runtime Exception thrown when encrypting: " + plainTextData, (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    public String decrypt(String encryptedData) {
        log.debug("Decrypting data...");
        try {
            String processed = new String(this.decodeFromString(encryptedData));
            log.debug("Decryption done.");
            return processed;
        }
        catch (Exception runtimeException) {
            log.error("Runtime Exception thrown when decrypting: " + encryptedData, (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    private String encodeToString(byte[] src) {
        return Base64.getEncoder().encodeToString(src);
    }

    private byte[] decodeFromString(String src) {
        return Base64.getDecoder().decode(src);
    }
}

