package com.atlassian.db.config.password;

/**
 * Implementation should provide public empty constructor,
 * which will be called by {@link CipherProvider#getInstance(String)} using reflection
 */
public interface Cipher {

    /**
     * Used to encrypt data stored in plain text.
     *
     * @param plainTextData data in plain text which should be encrypted
     * @return encrypted password to be saved in the configuration file
     * @throws RuntimeException in case any problem with encryption
     *
     */
    String encrypt(String plainTextData);

    /**
     * Used to decrypt encrypted by {@link Cipher#encrypt(String)} data
     *
     * @param encryptedData data which has been encrypted by using {@link #encrypt(String)}
     * @return plain text data, password which can be used to connect with the data base
     * @throws RuntimeException in case any problem with decryption
     */
    String decrypt(String encryptedData);
}
