/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.google.common.base.Function;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public final class IdentifierUtils {
    private static Locale IDENTIFIER_COMPARE_LOCALE;
    public static final Function<String, String> TO_LOWER_CASE;

    private IdentifierUtils() {
    }

    public static void prepareIdentifierCompareLocale() {
        String preferredLang = System.getProperty("crowd.identifier.language");
        IDENTIFIER_COMPARE_LOCALE = StringUtils.isNotBlank((String)preferredLang) ? new Locale(preferredLang) : Locale.ENGLISH;
    }

    public static String toLowerCase(String identifier) {
        return identifier.toLowerCase(IDENTIFIER_COMPARE_LOCALE);
    }

    public static int compareToInLowerCase(String identifier1, String identifier2) {
        return IdentifierUtils.toLowerCase(identifier1).compareTo(IdentifierUtils.toLowerCase(identifier2));
    }

    public static boolean equalsInLowerCase(String identifier1, String identifier2) {
        if (identifier1 == null) {
            return identifier2 == null;
        }
        return identifier2 != null && IdentifierUtils.compareToInLowerCase(identifier1, identifier2) == 0;
    }

    public static boolean hasLeadingOrTrailingWhitespace(String s) {
        return !s.equals(s.trim());
    }

    static {
        IdentifierUtils.prepareIdentifierCompareLocale();
        TO_LOWER_CASE = new Function<String, String>(){

            public String apply(String from) {
                return from.toLowerCase(IDENTIFIER_COMPARE_LOCALE);
            }
        };
    }
}

