/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.xwork.interceptors;

import com.atlassian.crowd.xwork.ParameterSafe;
import com.atlassian.crowd.xwork.XWorkVersionSupport;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.NoParameters;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeParametersInterceptor
implements Interceptor {
    public static final Logger log = LoggerFactory.getLogger(SafeParametersInterceptor.class);
    private static final Pattern SAFE_PARAMETER_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9\\.\\]\\[_']+");
    private static final Pattern MAP_PARAMETER_PATTERN = Pattern.compile(".*\\['[a-zA-Z0-9_]+'\\]");
    private final XWorkVersionSupport versionSupport = new XWorkVersionSupport();
    private boolean disableAnnotationChecks = false;

    public void init() {
    }

    public void destroy() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        this.before(invocation);
        return invocation.invoke();
    }

    public void setDisableAnnotationChecks(boolean disableAnnotationChecks) {
        this.disableAnnotationChecks = disableAnnotationChecks;
    }

    protected boolean shouldNotIntercept(ActionInvocation actionInvocation) {
        return this.versionSupport.extractAction(actionInvocation) instanceof NoParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void before(ActionInvocation invocation) throws Exception {
        if (this.shouldNotIntercept(invocation)) {
            return;
        }
        Action action = this.versionSupport.extractAction(invocation);
        Map<String, Object> parameters = this.filterSafeParameters(ActionContext.getContext().getParameters(), action);
        if (log.isDebugEnabled()) {
            log.debug("Setting params " + parameters);
        }
        ActionContext invocationContext = invocation.getInvocationContext();
        try {
            invocationContext.put((Object)"xwork.NullHandler.createNullObjects", (Object)Boolean.TRUE);
            invocationContext.put((Object)"xwork.MethodAccessor.denyMethodExecution", (Object)Boolean.TRUE);
            invocationContext.put((Object)"report.conversion.errors", (Object)Boolean.TRUE);
            if (parameters != null) {
                OgnlValueStack stack = ActionContext.getContext().getValueStack();
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    String name = entry.getKey();
                    stack.setValue(name, entry.getValue());
                }
            }
        }
        finally {
            invocationContext.put((Object)"xwork.NullHandler.createNullObjects", (Object)Boolean.FALSE);
            invocationContext.put((Object)"xwork.MethodAccessor.denyMethodExecution", (Object)Boolean.FALSE);
            invocationContext.put((Object)"report.conversion.errors", (Object)Boolean.FALSE);
        }
    }

    private Map<String, Object> filterSafeParameters(Map<String, ?> parameters, Action action) {
        HashMap<String, Object> safeParameters = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            if (!SafeParametersInterceptor.isSafeParameterName(entry.getKey(), action, this.disableAnnotationChecks)) continue;
            safeParameters.put(entry.getKey(), entry.getValue());
        }
        return safeParameters;
    }

    static boolean isSafeParameterName(String key, Action action) {
        return SafeParametersInterceptor.isSafeParameterName(key, action, true);
    }

    static boolean isSafeParameterName(String key, Action action, boolean disableAnnotationChecks) {
        if (!SAFE_PARAMETER_NAME_PATTERN.matcher(key).matches()) {
            return false;
        }
        if (!disableAnnotationChecks && (key.contains(".") || MAP_PARAMETER_PATTERN.matcher(key).matches())) {
            return SafeParametersInterceptor.isSafeComplexParameterName(key, action);
        }
        return true;
    }

    private static boolean isSafeComplexParameterName(String key, Action action) {
        try {
            PropertyDescriptor[] descs;
            String initialParameterName = SafeParametersInterceptor.extractInitialParameterName(key);
            BeanInfo info = Introspector.getBeanInfo(action.getClass());
            for (PropertyDescriptor desc : descs = info.getPropertyDescriptors()) {
                if (!desc.getName().equals(initialParameterName)) continue;
                if (SafeParametersInterceptor.isSafeMethod(desc.getReadMethod())) {
                    return true;
                }
                log.info("Attempt to call unsafe property setter " + key + " on " + action);
                return false;
            }
        }
        catch (IntrospectionException e) {
            log.warn("Error introspecting action parameter " + key + " for action " + action + ": " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static String extractInitialParameterName(String key) {
        if (!key.contains("[") || key.indexOf(".") > 0 && key.indexOf("[") > key.indexOf(".")) {
            return key.substring(0, key.indexOf("."));
        }
        return key.substring(0, key.indexOf("["));
    }

    private static boolean isSafeMethod(Method writeMethod) {
        return writeMethod.getAnnotation(ParameterSafe.class) != null || writeMethod.getReturnType().getAnnotation(ParameterSafe.class) != null;
    }
}

