/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.util;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import java.util.Random;
import java.util.UUID;

public class TestUserBuilder {
    private UserTemplateWithCredentialAndAttributes user;

    private TestUserBuilder() {
        String username = "user-" + UUID.randomUUID();
        this.user = new UserTemplateWithCredentialAndAttributes((User)new UserTemplate(username, "first-" + username, "last-" + username, "display-" + username), PasswordCredential.unencrypted((String)UUID.randomUUID().toString()));
        this.user.setActive(true);
    }

    public static UserTemplateWithCredentialAndAttributes buildUser(String userName, Long directoryId) {
        return TestUserBuilder.buildUser(userName, directoryId, true);
    }

    public static UserTemplateWithCredentialAndAttributes buildUser(String userName, Long directoryId, boolean active) {
        return TestUserBuilder.buildUser(userName, "test@example.com", "Test", "User", directoryId, active);
    }

    public static UserTemplateWithCredentialAndAttributes buildUser(String userName, String emailAddress, String firstName, String lastName, Long directoryId, boolean active) {
        return TestUserBuilder.newUser().name(userName).email(emailAddress).firstName(firstName).lastName(lastName).directory(directoryId).active(active).build();
    }

    public static TestUserBuilder newUser() {
        return new TestUserBuilder();
    }

    public static TestUserBuilder newUser(String username) {
        return TestUserBuilder.newUser(username, new Random().nextInt());
    }

    public static TestUserBuilder newUser(User user) {
        return new TestUserBuilder().name(user.getName()).externalId(user.getExternalId()).firstName(user.getFirstName()).lastName(user.getLastName()).directory(user.getDirectoryId()).displayName(user.getDisplayName()).email(user.getEmailAddress());
    }

    public static TestUserBuilder newUser(String username, long directoryId) {
        return new TestUserBuilder().name(username).directory(directoryId);
    }

    public TestUserBuilder name(String username) {
        this.user.setName(username);
        return this;
    }

    public TestUserBuilder directory(long directoryId) {
        this.user.setDirectoryId(directoryId);
        return this;
    }

    public TestUserBuilder firstName(String firstName) {
        this.user.setFirstName(firstName);
        return this;
    }

    public TestUserBuilder lastName(String lastName) {
        this.user.setLastName(lastName);
        return this;
    }

    public TestUserBuilder displayName(String displayName) {
        this.user.setDisplayName(displayName);
        return this;
    }

    public TestUserBuilder active(boolean active) {
        this.user.setActive(active);
        return this;
    }

    public TestUserBuilder email(String email) {
        this.user.setEmailAddress(email);
        return this;
    }

    public TestUserBuilder externalId(String externalId) {
        this.user.setExternalId(externalId);
        return this;
    }

    public UserTemplateWithCredentialAndAttributes build() {
        return new UserTemplateWithCredentialAndAttributes((User)this.user, new PasswordCredential(this.user.getCredential()));
    }
}

