/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.util;

import com.atlassian.crowd.plugin.rest.entity.admin.ApplicationEntity;
import com.atlassian.crowd.plugin.rest.entity.admin.DirectoryMappingAuthenticationEntity;
import com.atlassian.crowd.plugin.rest.entity.admin.DirectoryMappingEntity;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.cookie.CookieFilter;
import io.restassured.http.ContentType;
import io.restassured.path.json.config.JsonParserType;
import io.restassured.path.json.config.JsonPathConfig;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class RestUtils {
    protected static final String ADMIN_USER = "admin";
    protected static final String ADMIN_PW = "admin";

    private RestUtils() {
    }

    public static RequestSpecification adminRequest() {
        return RestAssured.given().auth().preemptive().basic("admin", "admin").contentType(ContentType.JSON).accept(ContentType.JSON);
    }

    public static void assertScheduledJobProperty(String baseUrl, String id, String field, Matcher<?> matcher) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestUtils.adminRequest().get(baseUrl + "/rest/admin/1.0/scheduler/jobs", new Object[0])).then()).assertThat()).body("jobs.find {it.id == \"" + id + "\"}." + field, matcher, new Object[0]);
    }

    public static void setPluginSetting(String baseUrl, String key, Object value) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestUtils.adminRequest().body((Object)ImmutableMap.of((Object)"key", (Object)key, (Object)"value", (Object)value)).post(baseUrl + "/rest/pluginmanagement/settings/global", new Object[0])).then()).assertThat()).statusCode(204);
    }

    public static <T> T getPluginSetting(String baseUrl, String key) {
        return (T)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestUtils.adminRequest().get(baseUrl + "/rest/pluginmanagement/settings/global/" + key, new Object[0])).then()).assertThat()).statusCode(200)).extract().path("value", new String[0]);
    }

    public static boolean isClustered(String baseUrl) {
        return (Boolean)((ValidatableResponse)((Response)RestUtils.adminRequest().get(baseUrl + "/rest/admin/1.0/cluster", new Object[0])).then()).extract().path("clustered", new String[0]);
    }

    public static Collection<String> getClusterNodeIds(String baseUrl) {
        return (Collection)((ValidatableResponse)((Response)RestUtils.adminRequest().get(baseUrl + "/rest/admin/1.0/cluster", new Object[0])).then()).extract().path("nodes.id", new String[0]);
    }

    public static void setDirectoryMappingIndex(String baseUrl, String appName, String dirName, int index) {
        int appId = (Integer)((Response)RestUtils.adminRequest().get(baseUrl + "/rest/admin/latest/application", new Object[0])).path("values.find { it.name == '%s'}.id", new String[]{appName});
        int dirId = (Integer)((Response)RestUtils.adminRequest().get(baseUrl + "/rest/admin/latest/application/{appId}/directory-mapping", new Object[]{appId})).path("values.find{ it.name == '%s'}.id", new String[]{dirName});
        RestUtils.setDirectoryMappingIndex(baseUrl, appId, dirId, index);
    }

    public static ApplicationEntity getApplication(String baseUrl, String applicationName) {
        return (ApplicationEntity)((Response)RestUtils.adminRequest().get(baseUrl + "/rest/admin/latest/application", new Object[0])).jsonPath().getObject("values.find { it.name == '" + applicationName + "'}", ApplicationEntity.class);
    }

    public static List<DirectoryMappingEntity> getApplicationDirectoryMappings(String baseUrl, long appId) {
        return ((Response)RestUtils.adminRequest().queryParam("expand", new Object[]{"*"}).get(baseUrl + "/rest/admin/latest/application/{appId}/directory-mapping", new Object[]{appId})).jsonPath(new JsonPathConfig().defaultParserType(JsonParserType.JACKSON_1)).getList("values", DirectoryMappingEntity.class);
    }

    public static DirectoryMappingEntity getApplicationDirectoryMapping(String baseUrl, long appId, long directoryId) {
        return (DirectoryMappingEntity)((Response)RestUtils.adminRequest().queryParam("expand", new Object[]{"*"}).get(baseUrl + "/rest/admin/latest/application/{appId}/directory-mapping/{dirId}", new Object[]{appId, directoryId})).jsonPath(new JsonPathConfig().defaultParserType(JsonParserType.JACKSON_1)).getObject("", DirectoryMappingEntity.class);
    }

    public static void setDirectoryMappingIndex(String baseUrl, long appId, long dirId, int index) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestUtils.adminRequest().body((Object)ImmutableMap.of((Object)"position", (Object)index)).post(baseUrl + "/rest/admin/latest/application/{appId}/directory-mapping/{dirId}/move", new Object[]{appId, dirId})).then()).assertThat()).statusCode(204);
    }

    public static void addDirectoryMapping(String baseUrl, long appId, long dirId) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestUtils.adminRequest().body((Object)new DirectoryMappingEntity(Long.valueOf(dirId), null, new DirectoryMappingAuthenticationEntity(Boolean.valueOf(true), Collections.emptyList()), null)).post(baseUrl + "/rest/admin/latest/application/{appId}/directory-mapping", new Object[]{appId})).then()).assertThat()).statusCode(201);
    }

    public static CookieFilter loginAsAdmin(String baseUrl) {
        CookieFilter cookies = new CookieFilter();
        RequestSpecification request = RestAssured.given().filter((Filter)cookies);
        Response response = (Response)((Response)request.get(baseUrl + "/console/login.action", new Object[0])).thenReturn();
        java.util.regex.Matcher m = Pattern.compile("name=\\\"atl_token\\\"(\\W)*value=\\\"(.*)\\\"").matcher(response.getBody().asString());
        if (!m.find()) {
            Assert.fail();
        }
        String atlToken = m.group(2);
        ((Response)request.redirects().follow(true).contentType("application/x-www-form-urlencoded").param("j_username", new Object[]{"admin"}).param("j_password", new Object[]{"admin"}).param("atl_token", new Object[]{atlToken}).post(baseUrl + "/console/j_security_check", new Object[0])).thenReturn();
        return cookies;
    }
}

