/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.matchers;

import com.atlassian.crowd.model.user.User;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class UserMatcher<E extends User>
extends TypeSafeMatcher<E> {
    @Nullable
    private final Matcher<String> nameMatcher;
    @Nullable
    private final Matcher<Boolean> activeMatcher;
    @Nullable
    private final Matcher<String> externalIdMatcher;

    public UserMatcher(@Nullable Matcher<String> nameMatcher, @Nullable Matcher<Boolean> activeMatcher, @Nullable Matcher<String> externalIdMatcher) {
        this.nameMatcher = nameMatcher;
        this.activeMatcher = activeMatcher;
        this.externalIdMatcher = externalIdMatcher;
    }

    public static <T extends User> UserMatcher<T> user() {
        return new UserMatcher(null, null, null);
    }

    public static <T extends User> UserMatcher<T> user(Class<T> type) {
        return UserMatcher.user();
    }

    public static <T extends User> UserMatcher<T> userNamed(String name) {
        return UserMatcher.user().withNameOf(name);
    }

    public UserMatcher<E> withNameMatching(Matcher<String> nameMatcher) {
        return new UserMatcher<E>(nameMatcher, this.activeMatcher, this.externalIdMatcher);
    }

    public UserMatcher<E> withNameOf(String name) {
        return new UserMatcher<E>((Matcher<String>)Matchers.is((Object)name), this.activeMatcher, this.externalIdMatcher);
    }

    public UserMatcher<E> withActive(boolean active) {
        return new UserMatcher<E>(this.nameMatcher, (Matcher<Boolean>)Matchers.is((Object)active), this.externalIdMatcher);
    }

    public UserMatcher<E> withExternalIdMatching(Matcher<String> externalIdMatcher) {
        return new UserMatcher<E>(this.nameMatcher, this.activeMatcher, externalIdMatcher);
    }

    public UserMatcher<E> withExternalIdOf(String externalId) {
        return this.withExternalIdMatching((Matcher<String>)Matchers.is((Object)externalId));
    }

    protected boolean matchesSafely(E item) {
        return !(item == null || this.nameMatcher != null && !this.nameMatcher.matches((Object)item.getName()) || this.activeMatcher != null && !this.activeMatcher.matches((Object)item.isActive()) || this.externalIdMatcher != null && !this.externalIdMatcher.matches((Object)item.getExternalId()));
    }

    public void describeTo(Description description) {
        description.appendText("User");
        boolean useAnd = false;
        if (this.nameMatcher != null) {
            description.appendText(" with name ").appendDescriptionOf(this.nameMatcher);
            useAnd = true;
        }
        if (this.activeMatcher != null) {
            if (useAnd) {
                description.appendText(" and");
            }
            description.appendText(" with active ").appendDescriptionOf(this.activeMatcher);
            useAnd = true;
        }
        if (this.externalIdMatcher != null) {
            if (useAnd) {
                description.appendText(" and");
            }
            description.appendText(" with externalId ").appendDescriptionOf(this.externalIdMatcher);
        }
    }
}

