/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.matchers;

import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntity;
import com.atlassian.crowd.audit.AuditLogEntry;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.test.matchers.AuditLogEntityMatcher;
import com.atlassian.crowd.test.matchers.AuditLogEntryMatcher;
import com.google.common.base.Preconditions;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class AuditLogChangesetMatcher
extends TypeSafeMatcher<AuditLogChangeset> {
    private final AuditLogEventType eventType;
    private final Matcher<Iterable<? extends AuditLogEntity>> entities;
    private final Matcher<Iterable<? extends AuditLogEntry>> entries;

    private AuditLogChangesetMatcher(AuditLogEventType eventType, Matcher<Iterable<? extends AuditLogEntity>> entities, Matcher<Iterable<? extends AuditLogEntry>> entries) {
        this.eventType = eventType;
        this.entities = entities;
        this.entries = entries;
    }

    protected boolean matchesSafely(AuditLogChangeset item) {
        return !(item.getEventType() != this.eventType || this.entities != null && !this.entities.matches((Object)item.getEntities()) || this.entries != null && !this.entries.matches((Object)item.getEntries()));
    }

    public void describeTo(Description description) {
        description.appendText("a changeset with event type: ").appendValue((Object)this.eventType);
        if (this.entities != null) {
            description.appendText(", entities: ").appendDescriptionOf(this.entities);
        }
        if (this.entries != null) {
            description.appendText(", entries: ").appendDescriptionOf(this.entries);
        }
    }

    protected void describeMismatchSafely(AuditLogChangeset item, Description mismatchDescription) {
        mismatchDescription.appendText("was a changeset with event type: ").appendValue((Object)item.getEventType());
        if (this.entities != null) {
            mismatchDescription.appendText(", entities: ").appendValue((Object)item.getEntities());
        }
        if (this.entries != null) {
            mismatchDescription.appendText(", entries: ").appendValue((Object)item.getEntries());
        }
    }

    public static Builder changeset() {
        return new Builder();
    }

    public static class Builder {
        private AuditLogEventType eventType;
        private Matcher<Iterable<? extends AuditLogEntity>> entities;
        private Matcher<Iterable<? extends AuditLogEntry>> entries;

        public Builder withEventType(AuditLogEventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder withEntity(Matcher<Iterable<? extends AuditLogEntity>> entities) {
            Preconditions.checkState((this.entities == null ? 1 : 0) != 0, (Object)"Overwriting matchers");
            this.entities = entities;
            return this;
        }

        public Builder withEntity(AuditLogEntityMatcher entity) {
            return this.withEntity((Matcher<Iterable<? extends AuditLogEntity>>)Matchers.contains((Matcher)entity));
        }

        public Builder withEntities(AuditLogEntityMatcher ... entities) {
            return this.withEntity((Matcher<Iterable<? extends AuditLogEntity>>)Matchers.containsInAnyOrder((Matcher[])entities));
        }

        public Builder withEntry(AuditLogEntryMatcher entry) {
            Preconditions.checkState((this.entries == null ? 1 : 0) != 0, (Object)"Overwriting matchers");
            this.entries = Matchers.contains((Matcher)entry);
            return this;
        }

        public Builder withEntries(AuditLogEntryMatcher ... entries) {
            Preconditions.checkState((this.entries == null ? 1 : 0) != 0, (Object)"Overwriting matchers");
            this.entries = Matchers.containsInAnyOrder((Matcher[])entries);
            return this;
        }

        public Builder withNoEntities() {
            Preconditions.checkState((this.entities == null ? 1 : 0) != 0, (Object)"Overwriting matchers");
            this.entities = Matchers.emptyIterable();
            return this;
        }

        public AuditLogChangesetMatcher build() {
            return new AuditLogChangesetMatcher(this.eventType, this.entities, this.entries);
        }
    }
}

