/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.matchers;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.RemoteAddress;
import java.util.Set;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class ApplicationMatcher
extends TypeSafeMatcher<Application> {
    @Nullable
    private final Matcher<String> nameMatcher;
    @Nullable
    private final Matcher<Set<RemoteAddress>> remoteAddressesMatcher;

    private ApplicationMatcher(@Nullable Matcher<String> nameMatcher, @Nullable Matcher<Set<RemoteAddress>> remoteAddressesMatcher) {
        this.nameMatcher = nameMatcher;
        this.remoteAddressesMatcher = remoteAddressesMatcher;
    }

    public static ApplicationMatcher application() {
        return new ApplicationMatcher(null, null);
    }

    public static ApplicationMatcher applicationNamed(String name) {
        return ApplicationMatcher.application().withNameOf(name);
    }

    public ApplicationMatcher withNameMatching(Matcher<String> nameMatcher) {
        return new ApplicationMatcher(nameMatcher, this.remoteAddressesMatcher);
    }

    public ApplicationMatcher withNameOf(String name) {
        return new ApplicationMatcher((Matcher<String>)Matchers.is((Object)name), this.remoteAddressesMatcher);
    }

    public ApplicationMatcher withRemoteAddressesMatching(Matcher<Set<RemoteAddress>> remoteAddressesMatcher) {
        return new ApplicationMatcher(this.nameMatcher, remoteAddressesMatcher);
    }

    public ApplicationMatcher withRemoteAddressOf(Set<RemoteAddress> remoteAddresses) {
        return new ApplicationMatcher(this.nameMatcher, (Matcher<Set<RemoteAddress>>)Matchers.is(remoteAddresses));
    }

    protected boolean matchesSafely(Application item) {
        return !(item == null || this.nameMatcher != null && !this.nameMatcher.matches((Object)item.getName()) || this.remoteAddressesMatcher != null && !this.remoteAddressesMatcher.matches((Object)item.getRemoteAddresses()));
    }

    public void describeTo(Description description) {
        description.appendText("Application");
        if (this.nameMatcher != null) {
            description.appendText(" with name ").appendDescriptionOf(this.nameMatcher);
        }
        if (this.remoteAddressesMatcher != null) {
            description.appendText(" with remote addresses ").appendDescriptionOf(this.remoteAddressesMatcher);
        }
    }
}

