/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.base.azure;

import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.google.common.base.Charsets;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.matchers.Times;
import org.mockserver.model.Body;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;

public abstract class BaseAzureAdTest {
    protected static final String M400_RFP_GROUP_NAME = "M400 RFP";
    protected static final String M400_RFP_EXTERNAL_ID = "02b41e3e-86b9-4289-aab2-e1e71cd607a9";
    protected static final String M400_GROUP_DESCRIPTION = "This Group is for the local government agency RFP to provide communication devices.";
    protected static final String NEW_MANAGERS_GROUP_NAME = "New Managers April 2017";
    protected static final String NEW_MANAGERS_EXTERNAL_ID = "1acf978f-7292-446a-92f2-077371e6fa18";
    protected static final String ALL_EMPLOYEES_GROUP_NAME = "All Employees";
    protected static final String ALAN_STEINER_USER_NAME = "alans@CIE493742.onmicrosoft.com";
    protected static final String CIE_ADMINISTRATOR_USER_NAME = "admin@CIE493742.onmicrosoft.com";
    protected static final String ALICIA_THOMBER_USER_NAME = "aliciat@CIE493742.onmicrosoft.com";
    protected CacheLoader<String, String> cacheLoader = (CacheLoader)Mockito.mock(CacheLoader.class);

    @Before
    public void setUpCacheLoader() throws Exception {
        Mockito.when((Object)this.cacheLoader.load(Matchers.any())).thenReturn((Object)"token");
    }

    protected void setExpectations(String firstPageFileName, String endpoint, boolean validateSkipToken) throws IOException {
        try (InputStream firstPageStream = this.getClass().getResourceAsStream(firstPageFileName);){
            HttpRequest request = HttpRequest.request().withPath(this.getAzureAdApiVersion() + "/" + endpoint).withHeader("Authorization", new String[]{"token"});
            if (validateSkipToken) {
                request.withQueryStringParameter("$skipToken", new String[]{"X'44537074020001000000203A616C616E73404349453439333734322E6F6E6D6963726F736F66742E636F6D29557365725F64363666323930322D396431322D346666382D616230312D323165633637303630373966B900000000000000000000'"});
            }
            this.getMockServerClient().when(request, Times.once()).respond(HttpResponse.response().withHeader("Content-Type", new String[]{"application/json"}).withBody((Body)new JsonBody(IOUtils.toString((InputStream)firstPageStream, (Charset)Charsets.UTF_8).replace("${port_placeholder}", String.valueOf(this.getMockServerPort())))));
        }
    }

    protected abstract MockServerClient getMockServerClient();

    protected abstract int getMockServerPort();

    protected abstract String getAzureAdApiVersion();

    protected Matcher<Group> allEmployeesGroup() {
        return org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.hasProperty((String)"name", (Matcher)org.hamcrest.Matchers.is((Object)ALL_EMPLOYEES_GROUP_NAME)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"active", (Matcher)org.hamcrest.Matchers.is((Object)true)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"description", (Matcher)org.hamcrest.Matchers.nullValue()), (Matcher)org.hamcrest.Matchers.hasProperty((String)"externalId", (Matcher)org.hamcrest.Matchers.is((Object)"341411d0-aef5-4413-ad76-53f5da51bb12")), (Matcher)org.hamcrest.Matchers.hasProperty((String)"type", (Matcher)org.hamcrest.Matchers.is((Object)GroupType.GROUP)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"local", (Matcher)org.hamcrest.Matchers.is((Object)false)));
    }

    protected Matcher<Group> newManagersGroup() {
        return org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.hasProperty((String)"name", (Matcher)org.hamcrest.Matchers.is((Object)NEW_MANAGERS_GROUP_NAME)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"active", (Matcher)org.hamcrest.Matchers.is((Object)true)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"description", (Matcher)org.hamcrest.Matchers.is((Object)"New Managers training course for April 2017")), (Matcher)org.hamcrest.Matchers.hasProperty((String)"externalId", (Matcher)org.hamcrest.Matchers.is((Object)NEW_MANAGERS_EXTERNAL_ID)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"type", (Matcher)org.hamcrest.Matchers.is((Object)GroupType.GROUP)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"local", (Matcher)org.hamcrest.Matchers.is((Object)false)));
    }

    protected Matcher<Group> m400RfpGroup() {
        return org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.hasProperty((String)"name", (Matcher)org.hamcrest.Matchers.is((Object)M400_RFP_GROUP_NAME)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"active", (Matcher)org.hamcrest.Matchers.is((Object)true)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"description", (Matcher)org.hamcrest.Matchers.is((Object)M400_GROUP_DESCRIPTION)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"externalId", (Matcher)org.hamcrest.Matchers.is((Object)M400_RFP_EXTERNAL_ID)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"type", (Matcher)org.hamcrest.Matchers.is((Object)GroupType.GROUP)), (Matcher)org.hamcrest.Matchers.hasProperty((String)"local", (Matcher)org.hamcrest.Matchers.is((Object)false)));
    }

    protected Matcher<User> aliciaThomberUser() {
        return org.hamcrest.Matchers.allOf((Matcher[])new Matcher[]{org.hamcrest.Matchers.hasProperty((String)"name", (Matcher)org.hamcrest.Matchers.is((Object)ALICIA_THOMBER_USER_NAME)), org.hamcrest.Matchers.hasProperty((String)"active", (Matcher)org.hamcrest.Matchers.is((Object)true)), org.hamcrest.Matchers.hasProperty((String)"emailAddress", (Matcher)org.hamcrest.Matchers.is((Object)ALICIA_THOMBER_USER_NAME)), org.hamcrest.Matchers.hasProperty((String)"firstName", (Matcher)org.hamcrest.Matchers.is((Object)"Alicia")), org.hamcrest.Matchers.hasProperty((String)"lastName", (Matcher)org.hamcrest.Matchers.is((Object)"Thomber")), org.hamcrest.Matchers.hasProperty((String)"displayName", (Matcher)org.hamcrest.Matchers.is((Object)"Alicia Thomber")), org.hamcrest.Matchers.hasProperty((String)"externalId", (Matcher)org.hamcrest.Matchers.is((Object)"79c0ee07-2d51-49c1-b122-761ce30d7c27"))});
    }

    protected Matcher<User> alanSteinerUser() {
        return org.hamcrest.Matchers.allOf((Matcher[])new Matcher[]{org.hamcrest.Matchers.hasProperty((String)"name", (Matcher)org.hamcrest.Matchers.is((Object)ALAN_STEINER_USER_NAME)), org.hamcrest.Matchers.hasProperty((String)"active", (Matcher)org.hamcrest.Matchers.is((Object)false)), org.hamcrest.Matchers.hasProperty((String)"emailAddress", (Matcher)org.hamcrest.Matchers.is((Object)ALAN_STEINER_USER_NAME)), org.hamcrest.Matchers.hasProperty((String)"firstName", (Matcher)org.hamcrest.Matchers.is((Object)"Alan")), org.hamcrest.Matchers.hasProperty((String)"lastName", (Matcher)org.hamcrest.Matchers.is((Object)"Steiner")), org.hamcrest.Matchers.hasProperty((String)"displayName", (Matcher)org.hamcrest.Matchers.is((Object)"Alan Steiner")), org.hamcrest.Matchers.hasProperty((String)"externalId", (Matcher)org.hamcrest.Matchers.is((Object)"d66f2902-9d12-4ff8-ab01-21ec6706079f"))});
    }

    protected Matcher<User> cieAdministratorUser() {
        return org.hamcrest.Matchers.allOf((Matcher[])new Matcher[]{org.hamcrest.Matchers.hasProperty((String)"name", (Matcher)org.hamcrest.Matchers.is((Object)CIE_ADMINISTRATOR_USER_NAME)), org.hamcrest.Matchers.hasProperty((String)"active", (Matcher)org.hamcrest.Matchers.is((Object)true)), org.hamcrest.Matchers.hasProperty((String)"emailAddress", (Matcher)org.hamcrest.Matchers.is((Object)CIE_ADMINISTRATOR_USER_NAME)), org.hamcrest.Matchers.hasProperty((String)"firstName", (Matcher)org.hamcrest.Matchers.is((Object)"CIE")), org.hamcrest.Matchers.hasProperty((String)"lastName", (Matcher)org.hamcrest.Matchers.is((Object)"Administrator")), org.hamcrest.Matchers.hasProperty((String)"displayName", (Matcher)org.hamcrest.Matchers.is((Object)"CIE Administrator")), org.hamcrest.Matchers.hasProperty((String)"externalId", (Matcher)org.hamcrest.Matchers.is((Object)"f71f1f74-bf1f-4e6b-b266-c777ea76e2c7"))});
    }

    protected <T> Matcher<T> withDirectoryId(Matcher<T> entityMatcher) {
        return org.hamcrest.Matchers.allOf(entityMatcher, (Matcher)org.hamcrest.Matchers.hasProperty((String)"directoryId", (Matcher)org.hamcrest.Matchers.is((Object)1L)));
    }

    protected <T> Matcher<T> withDirectory(Matcher<T> entityMatcher, long directoryId) {
        return org.hamcrest.Matchers.allOf(entityMatcher, (Matcher)org.hamcrest.Matchers.hasProperty((String)"directory", (Matcher)org.hamcrest.Matchers.hasProperty((String)"id", (Matcher)org.hamcrest.Matchers.is((Object)directoryId))));
    }
}

