/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.synchronisation.cache.DirectoryCache;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MockDirectoryCache
implements DirectoryCache {
    public final Map<String, User> userMap = new HashMap<String, User>();
    public final Map<String, Group> groupMap = new HashMap<String, Group>();
    public final Map<String, Group> roleMap = new HashMap<String, Group>();
    public final Map<String, UserWithAttributes> userWithAttributesHashMap = new HashMap<String, UserWithAttributes>();
    public final Map<String, GroupWithAttributes> groupWithAttributesHashMap = new HashMap<String, GroupWithAttributes>();
    public final SetMultimap<String, String> userMembershipsMap = HashMultimap.create();
    public final SetMultimap<String, String> groupMembershipsMap = HashMultimap.create();
    private boolean userAttributeSyncCalled = false;
    private boolean groupAttributeSyncCalled = false;

    public void addOrUpdateCachedUsers(Collection<? extends User> users, Date syncStartDate) throws OperationFailedException {
        for (User user : users) {
            this.addOrUpdateCachedUser(user);
        }
    }

    public void deleteCachedUsersNotIn(Collection<? extends User> users, Date syncStartDate) throws OperationFailedException {
        this.userMap.clear();
        for (User user : users) {
            this.addOrUpdateCachedUser(user);
        }
    }

    public void deleteCachedUsersByGuid(Set<String> guids) throws OperationFailedException {
        for (String guid : guids) {
            this.deleteCachedUsersByGuid(guid);
        }
    }

    private void deleteCachedUsersByGuid(String guid) throws OperationFailedException {
        Optional<String> optionalUserName = this.findUserNameByGuid(guid);
        if (optionalUserName.isPresent()) {
            this.deleteCachedUser(optionalUserName.get());
        }
    }

    private Optional<String> findUserNameByGuid(String guid) {
        for (User user : this.userMap.values()) {
            if (!guid.equals(user.getExternalId())) continue;
            return Optional.of(user.getName());
        }
        return Optional.empty();
    }

    public void deleteCachedGroups(Set<String> groupnames) throws OperationFailedException {
        for (String groupname : groupnames) {
            this.deleteCachedGroup(groupname);
        }
    }

    public void addOrUpdateCachedGroups(Collection<? extends Group> groups, Date syncStartDate) throws OperationFailedException {
        for (Group group : groups) {
            this.addOrUpdateCachedGroup(group);
        }
    }

    public void deleteCachedGroupsByGuids(Set<String> guids) throws OperationFailedException {
        for (String guid : guids) {
            this.deleteCachedGroupByGuid(guid);
        }
    }

    private void deleteCachedGroupByGuid(String guid) throws OperationFailedException {
        Optional<String> groupName = this.findGroupNameByGuid(guid);
        if (groupName.isPresent()) {
            this.deleteCachedGroup(groupName.get());
        }
    }

    private Optional<String> findGroupNameByGuid(String guid) {
        for (Group group : this.groupMap.values()) {
            if (!guid.equals(group.getExternalId())) continue;
            return Optional.of(group.getName());
        }
        return Optional.empty();
    }

    public void deleteCachedGroupsNotIn(GroupType groupType, List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        if (groupType == GroupType.GROUP) {
            this.groupMap.clear();
        } else {
            this.roleMap.clear();
        }
        this.addOrUpdateCachedGroups(remoteGroups, null);
    }

    public void deleteCachedGroupsNotInByExternalId(Collection<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        this.addOrUpdateCachedGroups(remoteGroups, null);
    }

    public void deleteCachedGroups(List<String> groupnames) throws OperationFailedException {
        for (String groupname : groupnames) {
            this.deleteCachedGroup(groupname);
        }
    }

    public Collection<User> getUsers() {
        return this.userMap.values();
    }

    public Collection<Group> getGroups() {
        return this.groupMap.values();
    }

    public Collection<Group> getRoles() {
        return this.roleMap.values();
    }

    public void syncUserMembersForGroup(Group parentGroup, Collection<String> users) throws OperationFailedException {
        if (!this.groupMap.values().contains(parentGroup)) {
            throw new OperationFailedException("Group " + parentGroup.getName() + " not found in cache");
        }
        this.userMembershipsMap.replaceValues((Object)parentGroup.getName(), users);
    }

    public void addUserMembersForGroup(Group parentGroup, Set<String> remoteUsers) throws OperationFailedException {
        if (!this.groupMap.values().contains(parentGroup)) {
            throw new OperationFailedException("Group " + parentGroup.getName() + " not found in cache");
        }
        this.userMembershipsMap.putAll((Object)parentGroup.getName(), remoteUsers);
    }

    public void deleteUserMembersForGroup(Group parentGroup, Set<String> remoteUsers) throws OperationFailedException {
        if (!this.groupMap.values().contains(parentGroup)) {
            throw new OperationFailedException("Group " + parentGroup.getName() + " not found in cache");
        }
        remoteUsers.forEach(user -> this.userMembershipsMap.remove((Object)parentGroup.getName(), user));
    }

    public void syncGroupMembersForGroup(Group parentGroup, Collection<String> groups) throws OperationFailedException {
        if (!this.groupMap.values().contains(parentGroup)) {
            throw new OperationFailedException("Group " + parentGroup.getName() + " not found in cache");
        }
        this.groupMembershipsMap.replaceValues((Object)parentGroup.getName(), groups);
    }

    public void addGroupMembersForGroup(Group parentGroup, Set<String> groups) throws OperationFailedException {
        if (!this.groupMap.values().contains(parentGroup)) {
            throw new OperationFailedException("Group " + parentGroup.getName() + " not found in cache");
        }
        this.groupMembershipsMap.putAll((Object)parentGroup.getName(), groups);
    }

    public void deleteGroupMembersForGroup(Group parentGroup, Set<String> groups) throws OperationFailedException {
        if (!this.groupMap.values().contains(parentGroup)) {
            throw new OperationFailedException("Group " + parentGroup.getName() + " not found in cache");
        }
        groups.forEach(group -> this.groupMembershipsMap.remove((Object)parentGroup.getName(), group));
    }

    public void addOrUpdateCachedUser(User user) throws OperationFailedException {
        Optional<User> maybeUserByExternalId;
        if (!Strings.isNullOrEmpty((String)user.getExternalId()) && (maybeUserByExternalId = this.userMap.entrySet().stream().map(Map.Entry::getValue).filter(internalUser -> Objects.equals(internalUser.getExternalId(), user.getExternalId())).findFirst()).isPresent()) {
            User userByExternalId = maybeUserByExternalId.get();
            this.userMap.remove(userByExternalId.getName());
            this.userMap.put(user.getName(), user);
            return;
        }
        this.userMap.put(user.getName(), user);
    }

    public void deleteCachedUser(String username) throws OperationFailedException {
        this.userMap.remove(username);
    }

    public void addOrUpdateCachedGroup(Group group) throws OperationFailedException {
        if (group.getType() == GroupType.GROUP) {
            Optional<Group> maybeGroupByExternalId;
            if (!Strings.isNullOrEmpty((String)group.getExternalId()) && (maybeGroupByExternalId = this.groupMap.entrySet().stream().map(Map.Entry::getValue).filter(internalGroup -> Objects.equals(internalGroup.getExternalId(), group.getExternalId())).findFirst()).isPresent()) {
                Group groupByExternalId = maybeGroupByExternalId.get();
                this.groupMap.remove(groupByExternalId.getName());
                this.groupMap.put(group.getName(), group);
                return;
            }
            this.groupMap.put(group.getName(), group);
        } else {
            this.roleMap.put(group.getName(), group);
        }
    }

    public void deleteCachedGroup(String groupname) throws OperationFailedException {
        this.groupMap.remove(groupname);
    }

    public void addUserToGroup(String username, String groupName) throws OperationFailedException {
        this.validateGroupExists(groupName);
        this.userMembershipsMap.put((Object)groupName, (Object)username);
    }

    public void removeUserFromGroup(String username, String groupName) throws OperationFailedException {
        this.validateGroupExists(groupName);
        this.userMembershipsMap.remove((Object)groupName, (Object)username);
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws OperationFailedException {
        this.validateGroupExists(parentGroup);
        this.groupMembershipsMap.put((Object)parentGroup, (Object)childGroup);
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws OperationFailedException {
        this.validateGroupExists(parentGroup);
        this.groupMembershipsMap.remove((Object)parentGroup, (Object)childGroup);
    }

    public void syncGroupMembershipsForUser(String childUsername, Set<String> parentGroupNames) throws OperationFailedException {
        this.userMembershipsMap.asMap().forEach((key, value) -> value.remove(childUsername));
        for (String parentGroup : parentGroupNames) {
            this.validateGroupExists(parentGroup);
            this.userMembershipsMap.put((Object)parentGroup, (Object)childUsername);
        }
    }

    public void syncGroupMembershipsAndMembersForGroup(String groupName, Set<String> parentGroupNames, Set<String> childGroupNames) throws OperationFailedException {
        this.validateGroupExists(groupName);
        this.groupMembershipsMap.asMap().forEach((key, value) -> value.remove(groupName));
        for (String parentGroup : parentGroupNames) {
            this.validateGroupExists(parentGroup);
            this.groupMembershipsMap.put((Object)parentGroup, (Object)groupName);
        }
        this.groupMembershipsMap.replaceValues((Object)groupName, childGroupNames);
    }

    private void validateGroupExists(String groupName) throws OperationFailedException {
        if (!this.groupMap.containsKey(groupName)) {
            throw new OperationFailedException("Group " + groupName + " not found in cache");
        }
    }

    public Set<String> getAllUserGuids() {
        return ImmutableSet.copyOf((Collection)this.userMap.values().stream().map(User::getExternalId).collect(Collectors.toSet()));
    }

    public long getUserCount() {
        return this.userMap.size();
    }

    public Set<String> getAllGroupGuids() throws OperationFailedException {
        return ImmutableSet.copyOf((Collection)this.groupMap.values().stream().map(Group::getExternalId).collect(Collectors.toList()));
    }

    public long getGroupCount() throws OperationFailedException {
        return this.groupMap.size();
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException, OperationFailedException {
        if (this.userWithAttributesHashMap.containsKey(name)) {
            return this.userWithAttributesHashMap.get(name);
        }
        throw new UserNotFoundException(name);
    }

    public Map<String, String> findUsersByExternalIds(Set<String> externalIds) {
        return this.userWithAttributesHashMap.values().stream().filter(user -> externalIds.contains(user.getExternalId())).collect(Collectors.toMap(User::getExternalId, Principal::getName));
    }

    public Map<String, String> findGroupsByExternalIds(Set<String> externalIds) throws OperationFailedException {
        return this.groupMap.values().stream().filter(group -> externalIds.contains(group.getExternalId())).collect(Collectors.toMap(Group::getExternalId, DirectoryEntity::getName));
    }

    public Map<String, String> findGroupsExternalIdsByNames(Set<String> groupNames) throws OperationFailedException {
        return this.groupMap.entrySet().stream().filter(entry -> groupNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Group)entry.getValue()).getExternalId()));
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException, OperationFailedException {
        if (this.groupWithAttributesHashMap.containsKey(name)) {
            return this.groupWithAttributesHashMap.get(name);
        }
        throw new GroupNotFoundException(name);
    }

    public void applySyncingUserAttributes(String userName, Set<String> deletedAttributes, Map<String, Set<String>> storedAttributes) throws UserNotFoundException, OperationFailedException {
        this.userAttributeSyncCalled = true;
    }

    public void applySyncingGroupAttributes(String groupName, Set<String> deletedAttributes, Map<String, Set<String>> storedAttributes) throws GroupNotFoundException, OperationFailedException {
        this.groupAttributeSyncCalled = true;
    }

    public Group getGroup(String name) {
        return this.groupMap.get(name);
    }

    public Group getRole(String name) {
        return this.roleMap.get(name);
    }

    public boolean isUserAttributeSyncCalled() {
        return this.userAttributeSyncCalled;
    }

    public boolean isGroupAttributeSyncCalled() {
        return this.groupAttributeSyncCalled;
    }
}

