package com.atlassian.crowd.directory.synchronisation;


import javax.annotation.Nullable;

import com.google.common.base.Strings;

public class CacheSynchronisationResult {
    private final boolean success;
    private final String syncStatusToken;

    public static final CacheSynchronisationResult FAILURE = new CacheSynchronisationResult(false, null);

    public CacheSynchronisationResult(boolean success, @Nullable String syncStatusToken) {
        this.success = success;
        this.syncStatusToken = Strings.nullToEmpty(syncStatusToken);
    }

    public boolean isSuccess() {
        return success;
    }

    public String getSyncStatusToken() {
        return syncStatusToken;
    }
}
