/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.util.ResourceBundleProvider;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Locale;
import java.util.ResourceBundle;

public class PluginResourceBundleProvider
implements ResourceBundleProvider {
    private static final Predicate<ResourceDescriptor> I18N_FILTER = new Resources.TypeFilter("i18n");
    private final PluginAccessor pluginAccessor;
    private final Locale locale;
    private final PluginEventManager pluginEventManager;
    private final ResettableLazyReference<Iterable<ResourceBundle>> bundles = new ResettableLazyReference<Iterable<ResourceBundle>>(){

        protected Iterable<ResourceBundle> create() throws Exception {
            return PluginResourceBundleProvider.this.loadResourceBundles();
        }
    };

    public PluginResourceBundleProvider(PluginAccessor pluginAccessor, Locale locale, PluginEventManager pluginEventManager) {
        this.pluginAccessor = pluginAccessor;
        this.locale = locale;
        this.pluginEventManager = pluginEventManager;
    }

    public void init() {
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    public Iterable<ResourceBundle> getResourceBundles() {
        return (Iterable)this.bundles.get();
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.bundles.reset();
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.bundles.reset();
    }

    private Iterable<ResourceBundle> loadResourceBundles() {
        ImmutableList.Builder resources = ImmutableList.builder();
        for (Plugin plugin : this.pluginAccessor.getEnabledPlugins()) {
            resources.addAll(this.getResourceBundlesForPlugin(plugin));
        }
        return resources.build();
    }

    private Iterable<ResourceBundle> getResourceBundlesForPlugin(Plugin plugin) {
        ImmutableList.Builder resources = ImmutableList.builder();
        resources.addAll(this.getResourceBundlesForResourced(plugin, (Resourced)plugin));
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            resources.addAll(this.getResourceBundlesForResourced(plugin, (Resourced)moduleDescriptor));
        }
        return resources.build();
    }

    private Iterable<ResourceBundle> getResourceBundlesForResourced(Plugin plugin, Resourced resourced) {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)resourced.getResourceDescriptors(), I18N_FILTER), this.toResourceBundle(plugin)), (Predicate)Predicates.notNull());
    }

    private Function<ResourceDescriptor, ResourceBundle> toResourceBundle(final Plugin plugin) {
        return new Function<ResourceDescriptor, ResourceBundle>(){

            public ResourceBundle apply(ResourceDescriptor descriptor) {
                return ResourceBundle.getBundle(descriptor.getLocation(), PluginResourceBundleProvider.this.locale, plugin.getClassLoader());
            }
        };
    }
}

