/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask623GenerateExternalId
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask623GenerateExternalId.class);
    private final DirectoryDao directoryDao;
    private final UserDao userDao;
    private final Collection<String> errors = new ArrayList<String>();
    private static final EntityQuery<Directory> INTERNAL_DIRECTORIES_QUERY = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.INTERNAL)).returningAtMost(-1);

    public UpgradeTask623GenerateExternalId(DirectoryDao directoryDao, UserDao userDao) {
        this.directoryDao = directoryDao;
        this.userDao = userDao;
    }

    @Override
    public String getBuildNumber() {
        return "623";
    }

    @Override
    public String getShortDescription() {
        return "Generates unique externalIds for users in internal directories";
    }

    @Override
    public void doUpgrade() throws Exception {
        for (Directory directory : this.directoryDao.search(INTERNAL_DIRECTORIES_QUERY)) {
            log.debug("Generating externalIds for users in directory {}", (Object)directory.getId());
            EntityQuery allUsersInDirectoryQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
            for (User user : this.userDao.search(directory.getId().longValue(), allUsersInDirectoryQuery)) {
                if (!StringUtils.isBlank((CharSequence)user.getExternalId())) continue;
                this.generateExternalId(user);
            }
        }
    }

    private void generateExternalId(User user) {
        UserTemplate userTemplate = new UserTemplate(user);
        userTemplate.setExternalId(InternalDirectory.generateUniqueIdentifier());
        try {
            this.userDao.update((User)userTemplate);
        }
        catch (UserNotFoundException e) {
            String errorMessage = "Could not update user " + user.getName() + " in directory " + user.getDirectoryId();
            log.error(errorMessage, (Throwable)e);
            this.errors.add(errorMessage + ", error is " + e.getMessage());
        }
    }

    @Override
    public Collection<String> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }
}

