/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.crowd.util.I18nHelper;
import java.util.ArrayList;
import java.util.Collection;

public class UpgradeTask320
implements UpgradeTask {
    private Collection<String> errors = new ArrayList<String>();
    private ApplicationManager applicationManager;
    private I18nHelper i18nHelper;

    @Override
    public String getBuildNumber() {
        return "320";
    }

    @Override
    public String getShortDescription() {
        return "Updating application descriptions and types for Crowd's default applications";
    }

    @Override
    public void doUpgrade() throws Exception {
        String crowdName = IdentifierUtils.toLowerCase((String)this.i18nHelper.getText("application.name"));
        String crowdDesc = this.i18nHelper.getText("application.description");
        String demoName = this.i18nHelper.getText("demo.application.name");
        String demoDesc = this.i18nHelper.getText("demo.application.description");
        String openidName = this.i18nHelper.getText("crowdid.application.name");
        String openidDesc = this.i18nHelper.getText("crowdid.application.description");
        this.updateApplication(crowdName, crowdDesc, ApplicationType.CROWD, true);
        this.updateApplication(demoName, demoDesc, ApplicationType.GENERIC_APPLICATION, false);
        this.updateApplication(openidName, openidDesc, ApplicationType.GENERIC_APPLICATION, false);
    }

    private boolean updateApplication(String applicationName, String newDescription, ApplicationType newType, boolean required) {
        try {
            ApplicationImpl applicationImpl = ApplicationImpl.newInstance((Application)this.applicationManager.findByName(applicationName));
            applicationImpl.setDescription(newDescription);
            applicationImpl.setType(newType);
            this.applicationManager.update((Application)applicationImpl);
            return true;
        }
        catch (ApplicationNotFoundException e) {
            if (required) {
                this.errors.add("Could not find application to update: " + applicationName);
            }
            return false;
        }
        catch (ApplicationManagerException e) {
            this.errors.add("Could not update found application: " + applicationName);
            return false;
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }
}

