/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask212
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask212.class);
    public static final String SERVER_ID_KEY = "server.id";
    private PropertyManager propertyManager;
    private CrowdBootstrapManager bootstrapManager;
    private Collection<String> errors = new ArrayList<String>();

    @Override
    public String getBuildNumber() {
        return "212";
    }

    @Override
    public String getShortDescription() {
        return "Moving bootstrap serverID property from database to crowd.cfg.xml";
    }

    @Override
    public void doUpgrade() {
        String dbServerId = null;
        try {
            dbServerId = this.propertyManager.getProperty(SERVER_ID_KEY);
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        if (dbServerId != null) {
            try {
                this.bootstrapManager.setServerID(dbServerId);
                this.propertyManager.removeProperty(SERVER_ID_KEY);
            }
            catch (ConfigurationException e) {
                log.error("Failed to write 'server id' property to crowd.cfg.xml", (Throwable)e);
                this.errors.add("Failed to write 'server id' property to crowd.cfg.xml");
            }
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }
}

