/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.trusted;

import com.atlassian.crowd.trusted.InternalCurrentApplication;
import com.atlassian.crowd.trusted.KeyUtils;
import com.atlassian.crowd.trusted.TrustedApplicationStore;
import com.atlassian.security.auth.trustedapps.Application;
import com.atlassian.security.auth.trustedapps.ApplicationRetriever;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultCurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultTrustedApplication;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsConfigurationManager;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableList;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Collection;

public class CrowdTrustedApplicationsManager
implements TrustedApplicationsManager,
TrustedApplicationsConfigurationManager {
    private final EncryptionProvider encryptionProvider;
    private final TrustedApplicationStore trustedApplicationStore;
    private final LazyReference<CurrentApplication> currentApplication = new LazyReference<CurrentApplication>(){

        protected CurrentApplication create() throws Exception {
            InternalCurrentApplication internalCurrentApplication = CrowdTrustedApplicationsManager.this.getInternalCurrentApplication();
            return new DefaultCurrentApplication(CrowdTrustedApplicationsManager.this.encryptionProvider, KeyUtils.decodePublicKey(CrowdTrustedApplicationsManager.this.encryptionProvider, internalCurrentApplication.getPublicKey()), KeyUtils.decodePrivateKey(CrowdTrustedApplicationsManager.this.encryptionProvider, internalCurrentApplication.getPrivateKey()), internalCurrentApplication.getUid());
        }
    };

    public CrowdTrustedApplicationsManager(EncryptionProvider encryptionProvider, TrustedApplicationStore trustedApplicationStore) {
        this.encryptionProvider = encryptionProvider;
        this.trustedApplicationStore = trustedApplicationStore;
    }

    public CurrentApplication getCurrentApplication() {
        return (CurrentApplication)this.currentApplication.get();
    }

    public synchronized TrustedApplication getTrustedApplication(String id) {
        return this.trustedApplicationStore.getTrustedApplication(id);
    }

    public Application getApplicationCertificate(String url) throws ApplicationRetriever.RetrievalException {
        return this.encryptionProvider.getApplicationCertificate(url);
    }

    public TrustedApplication addTrustedApplication(Application app, RequestConditions conditions) {
        DefaultTrustedApplication trustedApp = new DefaultTrustedApplication(this.encryptionProvider, app.getPublicKey(), app.getID(), conditions);
        this.trustedApplicationStore.addTrustedApplication((TrustedApplication)trustedApp);
        return trustedApp;
    }

    public Collection<TrustedApplication> getTrustedApplications() {
        return ImmutableList.copyOf(this.trustedApplicationStore.getTrustedApplications());
    }

    public boolean deleteApplication(String id) {
        return this.trustedApplicationStore.deleteApplication(id);
    }

    private InternalCurrentApplication getInternalCurrentApplication() throws NoSuchProviderException, NoSuchAlgorithmException {
        InternalCurrentApplication internalCurrentApplication = this.trustedApplicationStore.getCurrentApplication();
        if (internalCurrentApplication == null) {
            KeyPair keyPair = this.encryptionProvider.generateNewKeyPair();
            internalCurrentApplication = new InternalCurrentApplication(this.encryptionProvider.generateUID(), KeyUtils.encode(keyPair.getPrivate()), KeyUtils.encode(keyPair.getPublic()));
            this.trustedApplicationStore.storeCurrentApplication(internalCurrentApplication);
        }
        return internalCurrentApplication;
    }
}

