/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.factory;

import com.atlassian.crowd.plugin.PluginDirectoryLocator;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.web.context.ServletContextAware;

public class BundledPluginLoaderFactory
implements FactoryBean<BundledPluginLoader>,
ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(BundledPluginLoaderFactory.class);
    private final PluginDirectoryLocator pluginDirectoryLocator;
    private final List<PluginFactory> pluginFactories;
    private final PluginEventManager pluginEventManager;
    private final String bundledPluginFileName;
    private static final String ATLASSIAN_PLUGINS_BUNDLED_DISABLE = "atlassian.plugins.bundled.disable";
    private ServletContext servletContext;

    public BundledPluginLoaderFactory(PluginDirectoryLocator pluginDirectoryLocator, List<PluginFactory> pluginFactories, PluginEventManager pluginEventManager, String bundledPluginFileName) {
        this.pluginDirectoryLocator = pluginDirectoryLocator;
        this.pluginFactories = pluginFactories;
        this.pluginEventManager = pluginEventManager;
        this.bundledPluginFileName = bundledPluginFileName;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    URL getBundledPluginsUrl() throws MalformedURLException {
        File f;
        try {
            URI uri = new URI(this.bundledPluginFileName);
            if (uri.isAbsolute()) {
                return uri.toURL();
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        String realPath = this.servletContext.getRealPath("/WEB-INF/classes/" + this.bundledPluginFileName);
        if (realPath != null && (f = new File(realPath)).exists()) {
            return f.toURI().toURL();
        }
        URL bundledPluginsURL = this.servletContext.getResource(this.bundledPluginFileName);
        if (bundledPluginsURL == null) {
            throw new IllegalStateException("Could not load <" + this.bundledPluginFileName + "> from classpath");
        }
        return bundledPluginsURL;
    }

    public BundledPluginLoader getObject() throws Exception {
        if (Boolean.getBoolean(ATLASSIAN_PLUGINS_BUNDLED_DISABLE)) {
            log.warn("Bundled plugins have been disabled. Removing bundled plugin loader.");
            return null;
        }
        File frameworkBundlesDirectory = this.pluginDirectoryLocator.getBundledPluginsDirectory();
        URL bundledPluginsURL = this.getBundledPluginsUrl();
        if (Boolean.getBoolean("atlassian.dev.mode")) {
            log.info("We are in dev mode, using the following location for plugins <" + bundledPluginsURL.toExternalForm() + ">");
        }
        return new BundledPluginLoader(bundledPluginsURL, frameworkBundlesDirectory, this.pluginFactories, this.pluginEventManager);
    }

    public Class<BundledPluginLoader> getObjectType() {
        return BundledPluginLoader.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

