/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.SpringContainerContext;
import com.opensymphony.util.TextUtils;
import javax.servlet.ServletContext;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ComponentModuleDescriptor
extends AbstractModuleDescriptor
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ComponentModuleDescriptor.class);
    String alias;
    private ApplicationContext applicationContext;

    public ComponentModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.alias = element.attributeValue("alias");
        if (!TextUtils.stringSet((String)this.alias)) {
            this.alias = this.getKey();
        }
    }

    public Object getModule() {
        throw new UnsupportedOperationException("You cannot retrieve a component instance - Spring-ified");
    }

    public void enabled() {
        super.enabled();
        DefaultListableBeanFactory beanFactory = this.getGlobalBeanFactory();
        if (beanFactory != null) {
            if (beanFactory.containsBean(this.alias)) {
                throw new IllegalStateException("Can not overwrite an existing bean definition: " + this.alias);
            }
            log.debug("Creating bean definition for " + this.alias + " with class " + this.getModuleClass().getName());
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(this.getModuleClass(), 1, false);
            log.debug("Registering bean definition for " + this.alias + " with class " + this.getModuleClass().getName());
            beanFactory.registerBeanDefinition(this.alias, (BeanDefinition)rootBeanDefinition);
            Object o = beanFactory.getBean(this.alias);
            if (o instanceof StateAware) {
                StateAware sa = (StateAware)o;
                sa.enabled();
            }
        }
    }

    public void disabled() {
        DefaultListableBeanFactory beanFactory;
        if (log.isDebugEnabled()) {
            log.debug("Disabling component module " + this.getKey());
        }
        if ((beanFactory = this.getGlobalBeanFactory()) != null) {
            Object o = null;
            try {
                o = beanFactory.getBean(this.alias);
            }
            catch (NoSuchBeanDefinitionException nsbe) {
                // empty catch block
            }
            if (o != null && o instanceof StateAware) {
                StateAware sa = (StateAware)o;
                sa.disabled();
            }
            log.debug("Removing bean definition for " + this.alias);
            beanFactory.removeBeanDefinition(this.alias);
        }
        super.disabled();
    }

    private DefaultListableBeanFactory getGlobalBeanFactory() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
            if (configurableApplicationContext.getBeanFactory() instanceof DefaultListableBeanFactory) {
                return (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
            }
            log.error("Failed to lookup global bean factory - BeanFactory was not a DefaultListableBeanFactory?");
        } else {
            log.error("Failed to lookup global bean factory - ApplicationContext was not a ConfigurableApplicationContext?");
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private ApplicationContext getApplicationContextWithHack() {
        SpringContainerContext springContainerContext;
        ServletContext servletContext;
        if (this.applicationContext != null) {
            return this.applicationContext;
        }
        log.warn("Using hacks to get application context");
        ContainerContext containerContext = ContainerManager.getInstance().getContainerContext();
        if (containerContext instanceof SpringContainerContext && (servletContext = (springContainerContext = (SpringContainerContext)containerContext).getServletContext()) != null) {
            return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        }
        return null;
    }
}

