/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin;

import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.felix.FelixOsgiContainerManager;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdOsgiContainerManager
extends FelixOsgiContainerManager {
    private static final Logger log = LoggerFactory.getLogger(CrowdOsgiContainerManager.class);
    private final Cache<String, ServiceTracker> serviceTrackerCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).removalListener((RemovalListener)new ServiceTrackerRemovalListener()).build((CacheLoader)new ServiceTrackerLoader());

    public CrowdOsgiContainerManager(OsgiPersistentCache persistentCache, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) {
        super(persistentCache, packageScannerConfig, provider, eventManager);
    }

    public <T> T getOsgiComponentOfType(Class<T> clazz) {
        ServiceTracker serviceTracker;
        if (this.isRunning() && (serviceTracker = this.getServiceTrackerFromCache(clazz.getName())) != null) {
            return clazz.cast(serviceTracker.getService());
        }
        return null;
    }

    public void stop() throws OsgiContainerException {
        this.serviceTrackerCache.invalidateAll();
        super.stop();
    }

    private ServiceTracker getServiceTrackerFromCache(String className) {
        return (ServiceTracker)this.serviceTrackerCache.getUnchecked((Object)className);
    }

    private static class ServiceTrackerRemovalListener
    implements RemovalListener<String, ServiceTracker> {
        private ServiceTrackerRemovalListener() {
        }

        public void onRemoval(RemovalNotification<String, ServiceTracker> notification) {
            ServiceTracker serviceTracker = (ServiceTracker)notification.getValue();
            if (serviceTracker != null) {
                log.trace("Closing service tracker: {}", (Object)serviceTracker);
                serviceTracker.close();
            }
        }
    }

    private class ServiceTrackerLoader
    extends CacheLoader<String, ServiceTracker> {
        private ServiceTrackerLoader() {
        }

        public ServiceTracker load(String className) throws Exception {
            ServiceTracker serviceTracker = CrowdOsgiContainerManager.this.getServiceTracker(className);
            log.trace("Created service tracker for '{}': {}", (Object)className, (Object)serviceTracker);
            return serviceTracker;
        }
    }
}

