/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.dao.property.PropertyDAOHibernate;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMapper
extends GenericLegacyImporter
implements LegacyImporter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String PROPERTIES_XML_ROOT = "properties";
    protected static final String PROPERTY_XML_NODE = "property";
    protected static final String PROPERTY_XML_KEY = "key";
    protected static final String PROPERTY_XML_NAME = "name";
    protected static final String PROPERTY_XML_VALUE = "value";
    private final PropertyDAOHibernate propertyDAO;
    private final CrowdBootstrapManager bootstrapManager;

    public PropertyMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, PropertyDAOHibernate propertyDAO, CrowdBootstrapManager bootstrapManager) {
        super(sessionFactory, batchProcessor);
        this.propertyDAO = propertyDAO;
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element propertiesElement = (Element)root.selectSingleNode("/crowd/ properties");
        if (propertiesElement == null) {
            this.logger.error("No properties were found for importing!");
        } else {
            Iterator properties = propertiesElement.elementIterator();
            while (properties.hasNext()) {
                String name;
                Element propertyElemet = (Element)properties.next();
                String codeName = propertyElemet.element(PROPERTY_XML_NAME).getText();
                String value = propertyElemet.element(PROPERTY_XML_VALUE).getText();
                if (codeName.equals("22") && StringUtils.isNotBlank((CharSequence)value)) {
                    try {
                        this.bootstrapManager.setServerID(value);
                    }
                    catch (ConfigurationException e) {
                        throw new ImportException((Exception)((Object)e));
                    }
                }
                if ((name = this.getNameFromLegacyCode(codeName)) == null) continue;
                this.addEntityViaSave(new Property("crowd", name, value));
            }
        }
    }
}

