/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.token;

import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.manager.token.SearchableTokenService;
import com.atlassian.crowd.manager.token.SwitchableTokenManager;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@ThreadSafe
public class SwitchableTokenManagerImpl
implements SwitchableTokenManager,
SearchableTokenService {
    private final Logger logger = LoggerFactory.getLogger(SwitchableTokenManagerImpl.class);
    private final ReentrantReadWriteLock readWriteLock;
    @GuardedBy(value="readWriteLock")
    private TokenDAO implementation;
    @GuardedBy(value="readWriteLock")
    private final TokenDAO daoMemory;
    @GuardedBy(value="readWriteLock")
    private final TokenDAO daoHibernate;
    private final PropertyManager propertyManager;

    public SwitchableTokenManagerImpl(boolean initialUseIsMemory, TokenDAO daoMemory, TokenDAO daoHibernate, PropertyManager propertyManager, EventPublisher eventPublisher) {
        this.daoMemory = (TokenDAO)Preconditions.checkNotNull((Object)daoMemory);
        this.daoHibernate = (TokenDAO)Preconditions.checkNotNull((Object)daoHibernate);
        this.propertyManager = (PropertyManager)Preconditions.checkNotNull((Object)propertyManager);
        this.implementation = initialUseIsMemory ? daoMemory : daoHibernate;
        this.readWriteLock = new ReentrantReadWriteLock();
        eventPublisher.register((Object)this);
    }

    public SwitchableTokenManagerImpl(TokenDAO daoMemory, TokenDAO daoHibernate, PropertyManager propertyManager, EventPublisher eventPublisher) {
        this(Boolean.FALSE, daoMemory, daoHibernate, propertyManager, eventPublisher);
    }

    private void lockRead() {
        this.readWriteLock.readLock().lock();
    }

    private void unlockRead() {
        this.readWriteLock.readLock().unlock();
    }

    private void lockWrite() {
        this.readWriteLock.writeLock().lock();
    }

    private void unlockWrite() {
        this.readWriteLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token findByRandomHash(String randomHash) throws DataAccessException, ObjectNotFoundException {
        this.lockRead();
        try {
            Token token = this.implementation.findByRandomHash(randomHash);
            return token;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token findByIdentifierHash(String identifierHash) throws ObjectNotFoundException {
        this.lockRead();
        try {
            Token token = this.implementation.findByIdentifierHash(identifierHash);
            return token;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token add(Token token) throws DataAccessException {
        this.lockWrite();
        try {
            Token token2 = this.implementation.add(token);
            return token2;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token update(Token token) throws ObjectNotFoundException {
        this.lockWrite();
        try {
            Token token2 = this.implementation.update(token);
            return token2;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Token token) throws DataAccessException {
        this.lockWrite();
        try {
            this.implementation.remove(token);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> search(EntityQuery<? extends Token> query) {
        this.lockRead();
        try {
            List list = this.implementation.search(query);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long directoryID, String name) throws DataAccessException {
        this.lockWrite();
        try {
            this.implementation.remove(directoryID, name);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExcept(long directoryId, String name, String exclusionToken) {
        this.lockWrite();
        try {
            this.implementation.removeExcept(directoryId, name, exclusionToken);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(long directoryId) {
        this.lockWrite();
        try {
            this.implementation.removeAll(directoryId);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredTokens(Date currentTime, long maxLifeSeconds) {
        this.lockWrite();
        try {
            this.implementation.removeExpiredTokens(currentTime, maxLifeSeconds);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.lockWrite();
        try {
            this.daoMemory.removeAll();
            this.daoHibernate.removeAll();
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public boolean isUsingDatabaseStorage() {
        return this.implementation == this.daoHibernate;
    }

    @Override
    public void setUsingDatabaseStorage(boolean useDatabaseStorage) throws PropertyManagerException {
        this.propertyManager.setUsingDatabaseTokenStorage(useDatabaseStorage);
        if (useDatabaseStorage) {
            if (!this.isUsingDatabaseStorage()) {
                this.switchToHibernate();
            }
        } else if (this.isUsingDatabaseStorage()) {
            this.switchToMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToMemory() {
        this.logger.info("About to switch to in-memory token storage");
        this.lockWrite();
        try {
            if (this.implementation != this.daoHibernate) {
                throw new IllegalStateException("Cannot switch; already in memory caching mode");
            }
            this.move(this.daoMemory, this.daoHibernate);
            this.implementation = this.daoMemory;
        }
        finally {
            this.unlockWrite();
        }
        this.logger.info("Finished switch to in-memory token storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToHibernate() {
        this.logger.info("About to switch to database token storage");
        this.lockWrite();
        try {
            if (this.implementation != this.daoMemory) {
                throw new IllegalStateException("Cannot switch; already in database caching mode");
            }
            this.move(this.daoHibernate, this.daoMemory);
            this.implementation = this.daoHibernate;
        }
        finally {
            this.unlockWrite();
        }
        this.logger.info("Finished switch to database token storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void move(TokenDAO to, TokenDAO from) {
        this.lockWrite();
        try {
            Collection tokens = from.loadAll();
            if (tokens != null) {
                to.saveAll(tokens);
                from.removeAll();
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent event) {
        this.updateTokenStorage();
    }

    @EventListener
    public void onXMLRestoreFinishedEvent(XMLRestoreFinishedEvent event) {
        this.updateTokenStorage();
    }

    private void updateTokenStorage() {
        try {
            this.setUsingDatabaseStorage(this.propertyManager.isUsingDatabaseTokenStorage());
        }
        catch (PropertyManagerException e) {
            this.logger.error("Failed to set token storage on application startup", (Throwable)e);
        }
    }
}

