/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.license;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManagerException;
import com.atlassian.crowd.manager.license.CrowdLicenseStore;
import com.atlassian.crowd.manager.license.LicenseResourceEntity;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.util.build.BuildUtils;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.crowd.CrowdLicense;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CrowdLicenseManagerImpl
implements CrowdLicenseManager {
    private static final Logger log = LoggerFactory.getLogger(CrowdLicenseManagerImpl.class);
    private PropertyManager propertyManager;
    private ApplicationManager applicationManager;
    private DirectoryManager directoryManager;
    private CrowdLicenseStore licenseStore;
    private LicenseManager licenseManager;

    @Override
    public CrowdLicense getLicense() {
        return this.licenseStore.getLicense();
    }

    @Override
    public CrowdLicense storeLicense(String license) {
        return this.licenseStore.storeLicense(license);
    }

    @Override
    public boolean isLicenseValid() {
        return this.isLicenseValid(this.getLicense());
    }

    boolean isSetupLicenseValid(CrowdLicense license) {
        if (license == null) {
            return false;
        }
        if (license.isExpired() && license.isGracePeriodExpired()) {
            log.error("License has expired.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isSetupLicenseKeyValid(String key) {
        try {
            return this.isSetupLicenseValid(CrowdLicenseStore.getCrowdLicense(this.getAtlassianLicense(key)));
        }
        catch (LicenseException e) {
            log.error("Failed to validate license: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isLicenseValid(CrowdLicense license) {
        if (license == null) {
            return false;
        }
        if (license.isExpired() && license.isGracePeriodExpired()) {
            log.error("License has expired.");
            return false;
        }
        if (!license.isUnlimitedNumberOfUsers() && license.getMaximumNumberOfUsers() < this.propertyManager.getCurrentLicenseResourceTotal()) {
            log.error("License resource limit has been reached.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isLicenseKeyValid(String key) {
        try {
            return this.isLicenseValid(CrowdLicenseStore.getCrowdLicense(this.getAtlassianLicense(key)));
        }
        catch (LicenseException e) {
            log.error("Failed to validate license: " + e.getMessage());
            return false;
        }
    }

    AtlassianLicense getAtlassianLicense(String license) {
        if (license != null) {
            return this.licenseManager.getLicense(license);
        }
        return null;
    }

    @Override
    public int getCurrentResourceUsageTotal() throws CrowdLicenseManagerException {
        HashSet<GroupTemplate> processedGroups = new HashSet<GroupTemplate>();
        HashSet<Long> processedDirectories = new HashSet<Long>();
        HashSet<LicenseResourceEntity> licenseResourceEntities = new HashSet<LicenseResourceEntity>();
        try {
            List applications = this.applicationManager.findAll();
            for (Application application : applications) {
                for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
                    if (!directoryMapping.getDirectory().isActive()) continue;
                    Long directoryId = directoryMapping.getDirectory().getId();
                    if (directoryMapping.isAllowAllToAuthenticate()) {
                        if (!processedDirectories.contains(directoryId)) {
                            List activeUsers = this.directoryManager.searchUsers(directoryId.longValue(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true)).returningAtMost(-1));
                            licenseResourceEntities.addAll(this.buildResourceEntitiesFromUsernames(directoryId, activeUsers));
                        }
                        processedDirectories.add(directoryId);
                        continue;
                    }
                    for (GroupMapping groupMapping : directoryMapping.getAuthorisedGroups()) {
                        GroupTemplate group = new GroupTemplate(groupMapping.getGroupName(), groupMapping.getDirectory().getId().longValue(), GroupType.GROUP);
                        if (processedGroups.contains(group)) continue;
                        List users = this.directoryManager.searchNestedGroupRelationships(directoryMapping.getDirectory().getId().longValue(), QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(group.getName()).returningAtMost(-1));
                        licenseResourceEntities.addAll(this.buildResourceEntitiesFromUsers(directoryId, users));
                        processedGroups.add(group);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CrowdLicenseManagerException("Failed to calculate the current number of active user resources.", e);
        }
        return licenseResourceEntities.size();
    }

    private List<LicenseResourceEntity> buildResourceEntitiesFromUsernames(Long directoryId, List<String> usernames) {
        ArrayList<LicenseResourceEntity> userResourceList = new ArrayList<LicenseResourceEntity>();
        for (String username : usernames) {
            userResourceList.add(new LicenseResourceEntity(directoryId, username));
        }
        return userResourceList;
    }

    private List<LicenseResourceEntity> buildResourceEntitiesFromUsers(Long directoryId, List<User> users) {
        ArrayList<LicenseResourceEntity> userResourceList = new ArrayList<LicenseResourceEntity>();
        for (User user : users) {
            if (!user.isActive()) continue;
            userResourceList.add(new LicenseResourceEntity(directoryId, user.getName()));
        }
        return userResourceList;
    }

    @Override
    public boolean isResourceTotalOverLimit(float limit, int currentResourceCount) {
        if (this.getLicense().isUnlimitedNumberOfUsers()) {
            return false;
        }
        int userLimit = this.getLicense().getMaximumNumberOfUsers();
        float percentage = (float)currentResourceCount / (float)userLimit * 100.0f;
        log.debug("Percentage: " + percentage + "%");
        return percentage >= limit;
    }

    @Override
    public boolean isBuildWithinMaintenancePeriod(CrowdLicense license) {
        return license.getMaintenanceExpiryDate() == null || BuildUtils.getCurrentBuildDate().getTime() < license.getMaintenanceExpiryDate().getTime();
    }

    @Override
    public boolean isBuildWithinMaintenancePeriod(String key) {
        return this.isBuildWithinMaintenancePeriod(CrowdLicenseStore.getCrowdLicense(this.getAtlassianLicense(key)));
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setLicenseStore(CrowdLicenseStore licenseStore) {
        this.licenseStore = licenseStore;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }
}

