/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.backup;

import com.atlassian.crowd.file.FileConfigurationExporter;
import com.atlassian.crowd.manager.backup.BackupFileStore;
import com.atlassian.crowd.manager.backup.BackupManager;
import com.atlassian.crowd.manager.backup.BackupSummary;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.XmlMigrationManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class DefaultBackupManager
implements BackupManager {
    private final XmlMigrationManager xmlMigrationManager;
    private final FileConfigurationExporter fileConfigurationExporter;
    private final BackupFileStore backupFileStore;

    public DefaultBackupManager(XmlMigrationManager xmlMigrationManager, FileConfigurationExporter fileConfigurationExporter, BackupFileStore backupFileStore) {
        this.xmlMigrationManager = xmlMigrationManager;
        this.fileConfigurationExporter = fileConfigurationExporter;
        this.backupFileStore = backupFileStore;
    }

    @Override
    public String generateManualBackupFileName() {
        return this.generateFileName("atlassian-crowd-%s-backup-%s.xml");
    }

    @Override
    public String generateAutomatedBackupFileName() {
        return this.generateFileName("atlassian-crowd-%s-automated-backup-%s.xml");
    }

    @Override
    public String getBackupFileFullPath(String fileName) {
        File file = new File(this.backupFileStore.getBackupDirectory(), fileName);
        return file.getPath();
    }

    @Override
    @Transactional
    public synchronized long backup(String exportFileName, boolean resetDomain) throws ExportException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)exportFileName));
        String xmlExportFilePath = this.getBackupFileFullPath(exportFileName);
        String directoriesExportFilePath = this.getBackupFileFullPath("directories.properties");
        ImmutableMap options = ImmutableMap.of((Object)"OPTION_RESET_DOMAIN", (Object)resetDomain);
        long timeTaken = this.xmlMigrationManager.exportXml(xmlExportFilePath, (Map)options);
        this.fileConfigurationExporter.exportDirectories(directoriesExportFilePath);
        return timeTaken;
    }

    @Override
    public BackupSummary getAutomatedBackupSummary() {
        List<File> backupFiles = this.backupFileStore.getBackupFiles();
        int numBackups = backupFiles.size();
        Date oldest = null;
        Date youngest = null;
        if (numBackups > 0) {
            oldest = this.backupFileStore.extractTimestamp(backupFiles.get(0));
            youngest = this.backupFileStore.extractTimestamp(backupFiles.get(numBackups - 1));
        }
        return new BackupSummary(numBackups, oldest, youngest);
    }

    protected String generateFileName(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        String timestamp = sdf.format(new Date());
        return String.format(pattern, timestamp, "2.7.0-beta2");
    }
}

