/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.config.JdbcConfiguration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.BaseImporter;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.model.MembershipDTO;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.PasswordHelper;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

abstract class JdbcImporter
extends BaseImporter
implements Importer {
    protected JdbcOperations jdbcTemplate;
    protected PasswordHelper passwordHelper;

    public JdbcImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        super(directoryManager);
        Validate.notNull((Object)passwordHelper, (String)"passwordHelper cannot be null", (Object[])new Object[0]);
        this.passwordHelper = passwordHelper;
    }

    public abstract String getSelectAllUserGroupMembershipsSQL();

    public abstract RowMapper getMembershipMapper();

    public abstract String getSelectAllGroupsSQL();

    public abstract RowMapper getGroupMapper(Configuration var1);

    public abstract String getSelectAllUsersSQL();

    public abstract RowMapper getUserMapper(Configuration var1, PasswordHelper var2);

    @Override
    public Collection<GroupTemplate> findGroups(Configuration configuration) {
        return this.jdbcTemplate.query(this.getSelectAllGroupsSQL(), this.getGroupMapper(configuration));
    }

    public List<MembershipDTO> findUserToGroupMemberships(Configuration configuration) {
        return this.jdbcTemplate.query(this.getSelectAllUserGroupMembershipsSQL(), this.getMembershipMapper());
    }

    @Override
    public Collection<MembershipDTO> findGroupToGroupMemberships(Configuration configuration) throws ImporterException {
        throw new UnsupportedOperationException("Nested group not supported yet for jdbc-based imports");
    }

    public List<UserTemplateWithCredentialAndAttributes> findUsers(Configuration configuration) {
        return this.jdbcTemplate.query(this.getSelectAllUsersSQL(), this.getUserMapper(configuration, this.passwordHelper));
    }

    @Override
    public Class getConfigurationType() {
        return JdbcConfiguration.class;
    }

    @Override
    public void init(Configuration configuration) {
        this.setJdbcConfiguration((JdbcConfiguration)configuration);
    }

    private void setJdbcConfiguration(JdbcConfiguration configuration) {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource(configuration.getDatabaseDriver(), configuration.getDatabaseURL(), configuration.getUsername(), configuration.getPassword());
        this.jdbcTemplate = new JdbcTemplate((DataSource)driverManagerDataSource);
    }

    public void setJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

