/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.model.MembershipDTO;
import com.atlassian.crowd.importer.model.Result;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseImporter
implements Importer {
    protected final Logger logger = LoggerFactory.getLogger(BaseImporter.class);
    protected final DirectoryManager directoryManager;

    public BaseImporter(DirectoryManager directoryManager) {
        if (directoryManager == null) {
            throw new IllegalArgumentException("DirectoryManager cannot be null");
        }
        this.directoryManager = directoryManager;
    }

    protected Result importGroups(Collection<GroupTemplate> groups, Configuration configuration) throws ImporterException {
        Result importResult = new Result();
        if (groups != null) {
            this.logger.info("Importing " + groups.size() + " groups.");
            for (GroupTemplate group : groups) {
                group.setDirectoryId(configuration.getDirectoryID().longValue());
            }
            try {
                BulkAddResult opResult = this.directoryManager.addAllGroups(configuration.getDirectoryID().longValue(), groups, configuration.isOverwriteTarget().booleanValue());
                importResult.setGroupsImported(opResult.getAddedSuccessfully());
                for (Group entity : opResult.getFailedEntities()) {
                    importResult.addGroupFailedImport(entity.getName());
                }
                for (Group entity : opResult.getExistingEntities()) {
                    importResult.addExistingGroup(entity.getName());
                }
            }
            catch (Exception e) {
                this.logger.error("Error attempting to bulk import roles into directory with ID: " + configuration.getDirectoryID(), (Throwable)e);
                throw new ImporterException(e);
            }
        }
        return importResult;
    }

    protected Result importUsers(Collection<UserTemplateWithCredentialAndAttributes> users, Configuration configuration) throws ImporterException {
        Result importResult = new Result();
        if (users != null) {
            this.logger.info("Importing " + users.size() + " users.");
            for (UserTemplateWithCredentialAndAttributes user : users) {
                user.setDirectoryId(configuration.getDirectoryID().longValue());
                user.setExternalId(null);
            }
            try {
                BulkAddResult opResult = this.directoryManager.addAllUsers(configuration.getDirectoryID().longValue(), users, configuration.isOverwriteTarget().booleanValue());
                importResult.setUsersImported(opResult.getAddedSuccessfully());
                for (User entity : opResult.getFailedEntities()) {
                    importResult.addUsersFailedImport(entity.getName());
                }
                for (User entity : opResult.getExistingEntities()) {
                    importResult.addExistingUser(entity.getName());
                }
            }
            catch (Exception e) {
                this.logger.error("Error attempting to bulk import principals into directory with ID: " + configuration.getDirectoryID(), (Throwable)e);
                throw new ImporterException(e);
            }
        }
        return importResult;
    }

    private Map<String, Collection<String>> mapContainersToChildren(Iterable<? extends MembershipDTO> memberships) {
        HashMap<String, Collection<String>> containerToPrincipals = new HashMap<String, Collection<String>>();
        for (MembershipDTO membershipDTO : memberships) {
            if (containerToPrincipals.get(membershipDTO.getParentName()) == null) {
                containerToPrincipals.put(membershipDTO.getParentName(), new ArrayList());
            }
            ((Collection)containerToPrincipals.get(membershipDTO.getParentName())).add(membershipDTO.getChildName());
        }
        return containerToPrincipals;
    }

    protected Result importUserMemberships(Iterable<MembershipDTO> memberships, Configuration configuration) throws ImporterException {
        Result importResult = new Result();
        if (memberships != null) {
            this.logger.info("Importing user-to-group memberships.");
            Map<String, Collection<String>> groupToPrincipalsMap = this.mapContainersToChildren(memberships);
            try {
                for (Map.Entry<String, Collection<String>> groupAndMembers : groupToPrincipalsMap.entrySet()) {
                    try {
                        BulkAddResult opResult = this.directoryManager.addAllUsersToGroup(configuration.getDirectoryID().longValue(), groupAndMembers.getValue(), groupAndMembers.getKey());
                        importResult.addFailedUserMembershipImports(groupAndMembers.getKey(), opResult.getFailedEntities());
                        importResult.addFailedUserMembershipImports(groupAndMembers.getKey(), opResult.getExistingEntities());
                        importResult.addGroupMembershipsImported(opResult.getAddedSuccessfully());
                    }
                    catch (GroupNotFoundException e) {
                        this.logger.error("Could not add memberships for group '" + groupAndMembers.getKey() + "' as it does not exist in directory with ID: " + configuration.getDirectoryID(), (Throwable)e);
                        importResult.addFailedUserMembershipImports(groupAndMembers.getKey(), groupAndMembers.getValue());
                    }
                }
                this.logger.info("Completed importing " + importResult.getGroupMembershipsImported() + " user-to-group memberships.");
            }
            catch (Exception e) {
                this.logger.error("Error attempting to bulk import group relationships into directory with ID: " + configuration.getDirectoryID(), (Throwable)e);
                throw new ImporterException(e);
            }
        }
        return importResult;
    }

    protected Result importGroupMemberships(Iterable<MembershipDTO> memberships, Configuration configuration) throws ImporterException {
        Result importResult = new Result();
        if (memberships != null) {
            this.logger.info("Importing group-to-group memberships.");
            try {
                for (MembershipDTO membership : memberships) {
                    try {
                        this.directoryManager.addGroupToGroup(configuration.getDirectoryID().longValue(), membership.getChildName(), membership.getParentName());
                        importResult.addGroupMembershipsImported(1L);
                    }
                    catch (GroupNotFoundException e) {
                        this.logger.error("Could not add group '" + membership.getChildName() + "' as child of " + membership.getParentName() + " in directory with ID: " + configuration.getDirectoryID(), (Throwable)e);
                        importResult.addFailedGroupMembershipImport(membership);
                    }
                }
                this.logger.info("Completed importing " + importResult.getGroupMembershipsImported() + " group-to-group memberships.");
            }
            catch (Exception e) {
                this.logger.error("Error attempting to import group-to-group relationships into directory with ID: " + configuration.getDirectoryID(), (Throwable)e);
                throw new ImporterException(e);
            }
        }
        return importResult;
    }

    @Override
    public Result importUsersGroupsAndMemberships(Configuration configuration) throws ImporterException {
        Collection<UserTemplateWithCredentialAndAttributes> users;
        if (configuration == null || !this.getConfigurationType().isInstance(configuration)) {
            throw new IllegalArgumentException("The supplied configuration was of the incorrect type for this Importer, should have been: " + this.getConfigurationType().getCanonicalName());
        }
        this.init(configuration);
        Result finalImportResult = new Result();
        Collection<GroupTemplate> groups = this.findGroups(configuration);
        if (groups != null && !groups.isEmpty()) {
            Result groupsResult = this.importGroups(groups, configuration);
            finalImportResult.setGroupsImported(groupsResult.getGroupsImported());
            finalImportResult.setGroupsFailedImport(groupsResult.getGroupsFailedImport());
        }
        if ((users = this.findUsers(configuration)) != null && !users.isEmpty()) {
            Result usersResult = this.importUsers(users, configuration);
            finalImportResult.setUsersImported(usersResult.getUsersImported());
            finalImportResult.setUsersFailedImport(usersResult.getUsersFailedImport());
        }
        Result addedUserMembershipResult = this.importUserToGroupMemberships(configuration);
        Result addedGroupMembershipResult = this.importGroupToGroupMemberships(configuration);
        finalImportResult.setGroupMembershipsImported(addedUserMembershipResult.getGroupMembershipsImported() + addedGroupMembershipResult.getGroupMembershipsImported());
        finalImportResult.setGroupMembershipsFailedImport((Set<String>)Sets.union(addedUserMembershipResult.getGroupMembershipsFailedImport(), addedGroupMembershipResult.getGroupMembershipsFailedImport()));
        return finalImportResult;
    }

    private Result importUserToGroupMemberships(Configuration configuration) throws ImporterException {
        Collection<MembershipDTO> userToGroups = this.findUserToGroupMemberships(configuration);
        if (userToGroups != null) {
            return this.importUserMemberships(userToGroups, configuration);
        }
        return new Result();
    }

    private Result importGroupToGroupMemberships(Configuration configuration) throws ImporterException {
        Collection<MembershipDTO> groupToGroups;
        if (configuration.getImportNestedGroups().booleanValue() && (groupToGroups = this.findGroupToGroupMemberships(configuration)) != null) {
            return this.importGroupMemberships(groupToGroups, configuration);
        }
        return new Result();
    }

    @Override
    public boolean supportsMultipleDirectories(Configuration configuration) {
        return false;
    }

    @Override
    public Set<Directory> retrieveRemoteSourceDirectory(Configuration configuration) {
        return Collections.emptySet();
    }

    public abstract Collection<MembershipDTO> findUserToGroupMemberships(Configuration var1) throws ImporterException;

    public abstract Collection<MembershipDTO> findGroupToGroupMemberships(Configuration var1) throws ImporterException;

    public abstract Collection<GroupTemplate> findGroups(Configuration var1) throws ImporterException;

    public abstract Collection<UserTemplateWithCredentialAndAttributes> findUsers(Configuration var1) throws ImporterException;
}

