/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.console.action;

import com.atlassian.crowd.console.action.ActionHelper;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.extras.api.crowd.CrowdLicense;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.model.WebLink;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

class ActionHelperImpl
implements ActionHelper {
    private final CrowdBootstrapManager bootstrapManager;
    private final CrowdLicenseManager crowdLicenseManager;
    private final CrowdUserDetailsService crowdUserDetailsService;
    private final WebInterfaceManager webInterfaceManager;
    private final I18nHelper i18nHelper;

    public ActionHelperImpl(CrowdBootstrapManager bootstrapManager, CrowdLicenseManager crowdLicenseManager, CrowdUserDetailsService crowdUserDetailsService, WebInterfaceManager webInterfaceManager, I18nHelper i18nHelper) {
        this.bootstrapManager = (CrowdBootstrapManager)Preconditions.checkNotNull((Object)bootstrapManager);
        this.crowdLicenseManager = (CrowdLicenseManager)Preconditions.checkNotNull((Object)crowdLicenseManager);
        this.crowdUserDetailsService = (CrowdUserDetailsService)Preconditions.checkNotNull((Object)crowdUserDetailsService);
        this.webInterfaceManager = (WebInterfaceManager)Preconditions.checkNotNull((Object)webInterfaceManager);
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nHelper);
    }

    private static CrowdUserDetails getUser() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth != null && !(auth instanceof AnonymousAuthenticationToken) && auth.getPrincipal() instanceof CrowdUserDetails ? (CrowdUserDetails)auth.getPrincipal() : null;
    }

    @Override
    public CrowdLicense getLicense() {
        return this.crowdLicenseManager.getLicense();
    }

    @Override
    public boolean isLicenseExpired() {
        return this.isSetupComplete() && this.getLicense().isExpired();
    }

    @Override
    public boolean isEvaluation() {
        return this.isSetupComplete() && this.getLicense().isEvaluation();
    }

    @Override
    public boolean isSubscription() {
        return this.isSetupComplete() && this.getLicense().isSubscription();
    }

    @Override
    public boolean isWithinGracePeriod() {
        return this.isSetupComplete() && this.getLicense().isWithinGracePeriod();
    }

    @Override
    public boolean hasAdminRole(CrowdUserDetails userDetails) {
        String adminRole = this.crowdUserDetailsService.getAdminAuthority();
        for (GrantedAuthority grantedAuthority : userDetails.getAuthorities()) {
            if (!grantedAuthority.getAuthority().equals(adminRole)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAdmin() {
        CrowdUserDetails user = ActionHelperImpl.getUser();
        return user != null && this.hasAdminRole(user);
    }

    @Override
    public List<WebSectionModuleDescriptor> getWebSectionsForLocation(String location) {
        return this.webInterfaceManager.getDisplayableSections(location, this.getWebFragmentsContextMap());
    }

    @Override
    public List<WebItemModuleDescriptor> getWebItemsForSection(String sectionName) {
        return this.webInterfaceManager.getDisplayableItems(sectionName, this.getWebFragmentsContextMap());
    }

    @Override
    public String getDisplayableLink(WebLink link) {
        return link.getDisplayableUrl(ServletActionContext.getRequest(), this.getWebFragmentsContextMap());
    }

    @Override
    public String getSitemeshPageProperty(String propertyName) {
        return this.getSitemeshPageProperties().get(propertyName);
    }

    @Override
    public String getText(String key) {
        return this.i18nHelper.getText(key);
    }

    @Override
    public boolean isAuthenticated() {
        return this.isSetupComplete() && this.getRemoteUser() != null;
    }

    @Override
    public CrowdBootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    @Override
    public UserWithAttributes getRemoteUser() {
        CrowdUserDetails user = ActionHelperImpl.getUser();
        return user != null ? user.getRemotePrincipal() : null;
    }

    @Override
    public Map<String, Object> getWebFragmentsContextMap() {
        Map parameters = ActionContext.getContext().getParameters();
        Map transformedParameters = Maps.transformValues((Map)parameters, (Function)new Function<String[], String>(){

            public String apply(String[] input) {
                return Joiner.on((char)',').join((Object[])input);
            }
        });
        Map<String, String> sitemeshPageProperties = this.getSitemeshPageProperties();
        return ImmutableMap.builder().putAll(transformedParameters).putAll(sitemeshPageProperties).build();
    }

    @Override
    public Map<String, String> getSitemeshPageProperties() {
        Page page;
        PageContext pageContext = ServletActionContext.getPageContext();
        if (pageContext != null && (page = (Page)pageContext.getAttribute("sitemeshPage")) != null) {
            return page.getProperties();
        }
        return Collections.emptyMap();
    }

    private boolean isSetupComplete() {
        return this.bootstrapManager.isSetupComplete();
    }
}

