/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenLifetime;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.service.UserService;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserServiceImpl
implements UserService {
    private final ApplicationManager applicationManager;
    private final ApplicationService applicationService;
    private final TokenAuthenticationManager tokenAuthenticationManager;
    private final CrowdUserDetailsService crowdUserDetailsService;

    public UserServiceImpl(ApplicationManager applicationManager, ApplicationService applicationService, CrowdUserDetailsService crowdUserDetailsService, TokenAuthenticationManager tokenAuthenticationManager) {
        this.applicationManager = applicationManager;
        this.applicationService = applicationService;
        this.crowdUserDetailsService = crowdUserDetailsService;
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    @Override
    public String getRemoteUsername() {
        String username = null;
        CrowdUserDetails userDetails = this.getCrowdUserDetails();
        if (userDetails != null) {
            username = userDetails.getUsername();
        }
        return username;
    }

    private CrowdUserDetails getCrowdUserDetails() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && !(auth instanceof AnonymousAuthenticationToken) && auth.getPrincipal() != null && auth.getPrincipal() instanceof CrowdUserDetails) {
            return (CrowdUserDetails)auth.getPrincipal();
        }
        return null;
    }

    @Override
    public String getAuthenticatedUsername(HttpServletRequest request) {
        return this.getRemoteUsername();
    }

    @Override
    public boolean isUserInGroup(String username, String group) {
        Application application = this.getCrowdApplication();
        return this.applicationService.isUserNestedGroupMember(application, username, group);
    }

    private Application getCrowdApplication() {
        Application application;
        try {
            application = this.applicationManager.findByName(ApplicationType.CROWD.getDisplayName());
        }
        catch (ApplicationNotFoundException e) {
            throw new RuntimeException("Failed to find Crowd application for service, with name: <" + ApplicationType.CROWD.getDisplayName() + ">", e);
        }
        return application;
    }

    @Override
    public boolean isSystemAdmin(String username) throws DataAccessException {
        try {
            CrowdUserDetails userDetails = this.crowdUserDetailsService.loadUserByUsername(username);
            String adminRole = this.crowdUserDetailsService.getAuthorityPrefix() + this.crowdUserDetailsService.getAuthoritySuffix();
            for (GrantedAuthority grantedAuthority : userDetails.getAuthorities()) {
                if (!grantedAuthority.getAuthority().equals(adminRole)) continue;
                return true;
            }
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean authenticate(String username, String password) {
        UserAuthenticationContext context = this.buildUserAuthenticationContext(username, password);
        try {
            Token token = this.tokenAuthenticationManager.authenticateUser(context, TokenLifetime.USE_DEFAULT);
            if (token.getRandomHash() != null) {
                return true;
            }
        }
        catch (InvalidAuthenticationException e) {
            return false;
        }
        catch (OperationFailedException e) {
            throw new RuntimeException("Failed to authenticate user due to: " + e.getMessage(), e);
        }
        catch (InactiveAccountException e) {
            return false;
        }
        catch (ApplicationAccessDeniedException e) {
            return false;
        }
        catch (ExpiredCredentialException e) {
            return false;
        }
        catch (ApplicationNotFoundException e) {
            return false;
        }
        return false;
    }

    @Override
    public Principal resolve(String username) throws DataAccessException {
        CrowdUserDetails userDetails = this.crowdUserDetailsService.loadUserByUsername(username);
        if (userDetails != null) {
            UserTemplate userTemplate = new UserTemplate(userDetails.getUsername(), userDetails.getFirstName(), userDetails.getLastName(), userDetails.getFullName());
            userTemplate.setEmailAddress(userDetails.getEmail());
            return userTemplate;
        }
        return null;
    }

    private UserAuthenticationContext buildUserAuthenticationContext(String username, String password) {
        UserAuthenticationContext context = new UserAuthenticationContext();
        context.setApplication(ApplicationType.CROWD.getDisplayName());
        context.setName(username);
        context.setCredential(new PasswordCredential(password));
        context.setValidationFactors(new ValidationFactor[0]);
        return context;
    }
}

