/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import com.atlassian.crowd.migration.legacy.PartialXmlMapper;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

public class MembershipMapper
extends PartialXmlMapper
implements Mapper {
    private static final Set<DirectoryType> INCLUDED_DIRECTORY_TYPES = EnumSet.of(DirectoryType.INTERNAL, DirectoryType.DELEGATING, DirectoryType.CONNECTOR);
    private final MembershipDAOHibernate membershipDAO;
    private final DirectoryDAOHibernate directoryDAO;
    private final UserDAOHibernate userDAO;
    private final GroupDAOHibernate groupDAO;
    protected static final String MEMBERSHIP_XML_ROOT = "memberships";
    private static final String MEMBERSHIP_XML_NODE = "membership";
    private static final String MEMBERSHIP_XML_DIRECTORY_ID = "directoryId";
    private static final String MEMBERSHIP_XML_PARENT_NAME = "parentName";
    private static final String MEMBERSHIP_XML_CHILD_NAME = "childName";
    private static final String MEMBERSHIP_XML_PARENT_ID = "parentId";
    private static final String MEMBERSHIP_XML_CHILD_ID = "childId";
    private static final String MEMBERSHIP_XML_MEMBERSHIP_TYPE = "membershipType";
    private static final String MEMBERSHIP_XML_MEMBERSHIP_GROUP_TYPE = "groupType";

    public MembershipMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, MembershipDAOHibernate membershipDAO, DirectoryDAOHibernate directoryDAO, UserDAOHibernate userDAO, GroupDAOHibernate groupDAO, DirectoryManager directoryManager) {
        super(sessionFactory, batchProcessor, directoryManager, INCLUDED_DIRECTORY_TYPES);
        this.membershipDAO = membershipDAO;
        this.directoryDAO = directoryDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
    }

    @Override
    public Element exportXml(Map options) throws ExportException {
        Element membershipRoot = DocumentHelper.createElement((String)MEMBERSHIP_XML_ROOT);
        Iterable<InternalMembership> memberships = this.findAllExportableMemberships();
        for (InternalMembership membership : memberships) {
            this.addMembershipToXml(membership, membershipRoot);
        }
        return membershipRoot;
    }

    private Iterable<InternalMembership> findAllExportableMemberships() {
        List<Directory> exportableDirectories = this.findAllExportableDirectories();
        Predicate<Directory> requiresExportOfNonLocalGroups = new Predicate<Directory>(){

            public boolean apply(Directory directory) {
                return MembershipMapper.this.isExportOfNonLocalGroupsRequired(directory.getType());
            }
        };
        Collection directoriesThatExportAllMemberships = Collections2.filter(exportableDirectories, (Predicate)requiresExportOfNonLocalGroups);
        Collection directoriesThatExportOnlyLocalMemberships = Collections2.filter(exportableDirectories, (Predicate)Predicates.not((Predicate)requiresExportOfNonLocalGroups));
        return Iterables.concat((Iterable)this.membershipDAO.findAll(directoriesThatExportAllMemberships), (Iterable)this.membershipDAO.findAllLocal(directoriesThatExportOnlyLocalMemberships));
    }

    protected void addMembershipToXml(InternalMembership membership, Element membershipRoot) {
        Element membershipElement = membershipRoot.addElement(MEMBERSHIP_XML_NODE);
        membershipElement.addElement("id").addText(membership.getId().toString());
        membershipElement.addElement(MEMBERSHIP_XML_DIRECTORY_ID).addText(membership.getDirectory().getId().toString());
        membershipElement.addElement(MEMBERSHIP_XML_PARENT_NAME).addText(membership.getParentName());
        membershipElement.addElement(MEMBERSHIP_XML_CHILD_NAME).addText(membership.getChildName());
        membershipElement.addElement(MEMBERSHIP_XML_PARENT_ID).addText(membership.getParentId().toString());
        membershipElement.addElement(MEMBERSHIP_XML_CHILD_ID).addText(membership.getChildId().toString());
        membershipElement.addElement(MEMBERSHIP_XML_MEMBERSHIP_TYPE).addText(membership.getMembershipType().name());
        membershipElement.addElement(MEMBERSHIP_XML_MEMBERSHIP_GROUP_TYPE).addText(membership.getGroupType().name());
    }

    @Override
    public void importXml(Element root) throws ImportException {
        Element membershipsElement = (Element)root.selectSingleNode("/crowd/ memberships");
        if (membershipsElement == null) {
            this.logger.error("No memberships were found for importing!");
            return;
        }
        ArrayList<InternalMembership> membershipsToReplicate = new ArrayList<InternalMembership>();
        ArrayList<InternalUser> placeholderUsers = new ArrayList<InternalUser>();
        ArrayList<InternalGroup> placeholderGroups = new ArrayList<InternalGroup>();
        Iterator membershipIter = membershipsElement.elementIterator();
        while (membershipIter.hasNext()) {
            Element membershipElement = (Element)membershipIter.next();
            InternalMembership membership = this.getMembershipFromXml(membershipElement);
            if (!this.isImportableDirectory(membership.getDirectory())) continue;
            if (this.isPlaceholderUserNeeded(membership)) {
                placeholderUsers.add(MembershipMapper.createPlaceholderUser(membership.getChildId(), membership.getChildName(), membership.getDirectory()));
            } else if (this.isPlaceholderChildGroupNeeded(membership)) {
                placeholderGroups.add(MembershipMapper.createPlaceholderGroup(membership.getChildId(), membership.getChildName(), membership.getDirectory()));
            } else if (this.isPlaceholderParentGroupNeeded(membership)) {
                placeholderGroups.add(MembershipMapper.createPlaceholderGroup(membership.getParentId(), membership.getParentName(), membership.getDirectory()));
            }
            membershipsToReplicate.add(membership);
        }
        if (!placeholderUsers.isEmpty()) {
            this.logger.info("About to replicate {} cached users (they will be refreshed in the next synchronisation)", (Object)placeholderUsers.size());
            this.addEntities(placeholderUsers);
            this.logger.info("Cached users replication complete");
        }
        if (!placeholderGroups.isEmpty()) {
            this.logger.info("About to replicate {} cached groups (they will be refreshed in the next synchronisation)", (Object)placeholderGroups.size());
            this.addEntities(placeholderGroups);
            this.logger.info("Cached groups replication complete");
        }
        this.logger.info("About to replicate " + membershipsToReplicate.size() + " memberships");
        this.addEntities(membershipsToReplicate);
        this.logger.info("Membership replication complete");
    }

    private static InternalUser createPlaceholderUser(Long id, String name, Directory directory) {
        InternalEntityTemplate internalEntityTemplate = new InternalEntityTemplate(id, name, true, new Date(), new Date());
        UserTemplate userTemplate = new UserTemplate(name, directory.getId().longValue());
        userTemplate.setActive(true);
        return new InternalUser(internalEntityTemplate, directory, userTemplate, PasswordCredential.NONE);
    }

    private static InternalGroup createPlaceholderGroup(Long id, String name, Directory directory) {
        InternalEntityTemplate internalEntityTemplate = new InternalEntityTemplate(id, name, true, new Date(), new Date());
        GroupTemplate groupTemplate = new GroupTemplate(name, directory.getId().longValue());
        groupTemplate.setActive(true);
        return new InternalGroup(internalEntityTemplate, directory, groupTemplate);
    }

    private boolean isPlaceholderUserNeeded(InternalMembership membership) {
        return membership.getMembershipType().equals((Object)MembershipType.GROUP_USER) && !this.userExistsInDirectory(membership.getChildName(), membership.getDirectory());
    }

    private boolean isPlaceholderChildGroupNeeded(InternalMembership membership) {
        return membership.getMembershipType().equals((Object)MembershipType.GROUP_GROUP) && !this.groupExistsInDirectory(membership.getChildName(), membership.getDirectory());
    }

    private boolean isPlaceholderParentGroupNeeded(InternalMembership membership) {
        return membership.getMembershipType().equals((Object)MembershipType.GROUP_GROUP) && !this.groupExistsInDirectory(membership.getParentName(), membership.getDirectory());
    }

    private boolean userExistsInDirectory(String name, Directory directory) {
        try {
            this.userDAO.findByName(directory.getId().longValue(), name);
            return true;
        }
        catch (UserNotFoundException e) {
            return false;
        }
    }

    private boolean groupExistsInDirectory(String name, Directory directory) {
        try {
            this.groupDAO.findByName(directory.getId().longValue(), name);
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    protected InternalMembership getMembershipFromXml(Element membershipElement) {
        Long id = Long.parseLong(membershipElement.element("id").getText());
        Long directoryId = Long.parseLong(membershipElement.element(MEMBERSHIP_XML_DIRECTORY_ID).getText());
        Long childId = Long.parseLong(membershipElement.element(MEMBERSHIP_XML_CHILD_ID).getText());
        Long parentId = Long.parseLong(membershipElement.element(MEMBERSHIP_XML_PARENT_ID).getText());
        String childName = membershipElement.element(MEMBERSHIP_XML_CHILD_NAME).getText();
        String parentName = membershipElement.element(MEMBERSHIP_XML_PARENT_NAME).getText();
        MembershipType membershipType = MembershipType.valueOf((String)membershipElement.element(MEMBERSHIP_XML_MEMBERSHIP_TYPE).getText());
        GroupType groupType = GroupType.valueOf((String)membershipElement.element(MEMBERSHIP_XML_MEMBERSHIP_GROUP_TYPE).getText());
        DirectoryImpl directoryReference = (DirectoryImpl)this.directoryDAO.loadReference(directoryId.longValue());
        return new InternalMembership(id, parentId, childId, membershipType, groupType, parentName, childName, directoryReference);
    }
}

