/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

public class DirectoryMapper
extends GenericLegacyImporter
implements LegacyImporter {
    protected static final String DIRECTORY_XML_ROOT = "directories";
    protected static final String DIRECTORY_XML_NODE = "directory";
    private static final String DIRECTORY_XML_DESCRIPTION = "description";
    private static final String DIRECTORY_XML_IMPLEMENTATION_CLASS = "implementationClass";
    private static final String DIRECTORY_XML_TYPE = "type";
    private static final String DIRECTORY_XML_PERMISSIONS_NODE = "permissions";
    private static final String DIRECTORY_XML_PERMISSION = "permission";
    private static final String DIRECTORY_XML_PERMISSION_KEY = "key";
    private static final String DIRECTORY_XML_PERMISSION_VALUE = "value";

    public DirectoryMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor) {
        super(sessionFactory, batchProcessor);
    }

    @Override
    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element directoriesElement = (Element)root.selectSingleNode("/crowd/ directories");
        if (directoriesElement == null) {
            this.logger.error("No applications were found for importing!");
            return;
        }
        Iterator directories = directoriesElement.elementIterator();
        while (directories.hasNext()) {
            Element directoryElement = (Element)directories.next();
            this.importDirectoryFromXml(directoryElement, importData.getOldToNewDirectoryIds());
        }
    }

    protected DirectoryImpl importDirectoryFromXml(Element directoryElement, Map<Long, Long> oldToNewDirectoryIds) throws ImportException {
        InternalEntityTemplate template = this.getInternalEntityTemplateFromLegacyXml(directoryElement);
        Long oldDirectoryId = template.getId();
        template.setId(null);
        DirectoryImpl directory = new DirectoryImpl(template);
        directory.setDescription(directoryElement.element(DIRECTORY_XML_DESCRIPTION).getText());
        directory.setType(this.getDirectoryTypeFromLegacyCode(Integer.parseInt(directoryElement.element(DIRECTORY_XML_TYPE).getText())));
        directory.setImplementationClass(directoryElement.element(DIRECTORY_XML_IMPLEMENTATION_CLASS).getText());
        Map<String, String> attributes = this.getSingleValuedAttributesMapFromXml(directoryElement);
        directory.setAttributes(attributes);
        Set<OperationType> permissions = this.getPermissions(directoryElement);
        directory.setAllowedOperations(permissions);
        DirectoryImpl addedDirectory = (DirectoryImpl)this.addEntityViaMerge(directory);
        Long newDirectoryId = addedDirectory.getId();
        oldToNewDirectoryIds.put(oldDirectoryId, newDirectoryId);
        return directory;
    }

    private Set<OperationType> getPermissions(Element element) {
        HashSet<OperationType> permissions = new HashSet<OperationType>();
        Element permissionsNode = element.element(DIRECTORY_XML_PERMISSIONS_NODE);
        if (permissionsNode != null && permissionsNode.hasContent()) {
            Iterator iterator = permissionsNode.elementIterator(DIRECTORY_XML_PERMISSION);
            while (iterator.hasNext()) {
                OperationType operationType;
                Element permissionElement = (Element)iterator.next();
                if (!Boolean.valueOf(permissionElement.attributeValue(DIRECTORY_XML_PERMISSION_VALUE)).booleanValue() || (operationType = this.getOperationTypeFromLegacyPermissionName(permissionElement.attributeValue(DIRECTORY_XML_PERMISSION_KEY))) == null) continue;
                permissions.add(operationType);
            }
        } else {
            permissions.addAll(Arrays.asList(OperationType.values()));
        }
        return permissions;
    }
}

