/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.crowd.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;

public class UpgradeTask426
implements UpgradeTask {
    private static final int BATCH_SIZE = 20;
    private static final Logger log = Logger.getLogger(UpgradeTask426.class);
    private final Collection<String> errors = new ArrayList<String>();
    private DirectoryDao directoryDao;
    private UserDAOHibernate userDao;

    @Override
    public String getBuildNumber() {
        return "426";
    }

    @Override
    public String getShortDescription() {
        return "Updating users in internal directories to have non-empty display names and last names";
    }

    @Override
    public void doUpgrade() throws Exception {
        for (Directory directory : this.findAllInternalDirectories()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating users in directory " + directory));
            }
            try {
                this.updateDirectory(directory);
            }
            catch (DataAccessException e) {
                String errorMessage = "Could not update users in directory " + directory;
                log.error((Object)errorMessage, (Throwable)e);
                this.errors.add(errorMessage + ", error is " + e.getMessage());
            }
        }
    }

    private void updateDirectory(Directory directory) throws DataAccessException {
        this.userDao.getHibernateTemplate().flush();
        BooleanRestriction displayNameOrLastNameEmptyRestriction = Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.DISPLAY_NAME).exactlyMatching((Object)""), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).isNull(), Restriction.on((Property)UserTermKeys.LAST_NAME).exactlyMatching((Object)""), Restriction.on((Property)UserTermKeys.LAST_NAME).isNull()});
        List users = this.userDao.search(directory.getId().longValue(), QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)displayNameOrLastNameEmptyRestriction).returningAtMost(-1));
        this.userDao.getHibernateTemplate().clear();
        int counter = 0;
        for (User user : users) {
            try {
                this.userDao.update(UserUtils.populateNames((User)user));
            }
            catch (UserNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (++counter != 20) continue;
            counter = 0;
            this.userDao.getHibernateTemplate().flush();
            this.userDao.getHibernateTemplate().clear();
        }
    }

    private List<Directory> findAllInternalDirectories() {
        return this.directoryDao.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.INTERNAL)).returningAtMost(-1));
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    public void setUserDao(UserDAOHibernate userDao) {
        this.userDao = userDao;
    }
}

