/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class UpgradeTask113
implements UpgradeTask {
    private DirectoryManager directoryManager;
    private List<String> errors = new ArrayList<String>();

    @Override
    public String getBuildNumber() {
        return "113";
    }

    @Override
    public String getShortDescription() {
        return "Set encryption method for all current Internal Directories to be DES";
    }

    @Override
    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.INTERNAL)).returningAtMost(-1));
        for (DirectoryImpl directory : directories) {
            String userEncryption = directory.getValue("user_encryption_method");
            if (userEncryption != null) continue;
            directory.setAttribute("user_encryption_method", "des");
            try {
                this.directoryManager.updateDirectory((Directory)directory);
            }
            catch (DataAccessException e) {
                this.errors.add(e.getMessage());
                throw e;
            }
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

