/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.license.SIDManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class UpgradeTask001
implements UpgradeTask {
    private static final String TASK_NUMBER = "1";
    private static final Logger log = Logger.getLogger(UpgradeTask001.class);
    private List errors = new ArrayList();
    private CrowdBootstrapManager bootstrapManager;
    private SIDManager sidManager;

    @Override
    public String getBuildNumber() {
        return TASK_NUMBER;
    }

    @Override
    public String getShortDescription() {
        return "Sets the server id in the crowd.cfg.xml if one has not been set";
    }

    @Override
    public void doUpgrade() throws Exception {
        String crowdSid = this.bootstrapManager.getServerID();
        if (crowdSid == null) {
            crowdSid = this.sidManager.generateSID();
            try {
                this.bootstrapManager.setServerID(crowdSid);
            }
            catch (ConfigurationException e1) {
                log.error((Object)"Failed to set server id property", (Throwable)e1);
                this.errors.add("Failed to set server id property, please see logs for more information");
            }
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setSidManager(SIDManager sidManager) {
        this.sidManager = sidManager;
    }
}

