/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.verify;

import com.atlassian.crowd.migration.legacy.database.sql.LegacyTableQueries;
import com.atlassian.crowd.migration.verify.DatabaseVerifier;
import java.util.ArrayList;
import java.util.List;

public class DatabaseVerificationManager {
    private final List<DatabaseVerifier> verifiers;
    private LegacyTableQueries legacyTableQueries;

    public DatabaseVerificationManager(List<DatabaseVerifier> verifiers) {
        this.verifiers = verifiers;
    }

    public List<String> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        for (DatabaseVerifier verifier : this.verifiers) {
            if (!errors.isEmpty()) continue;
            verifier.clearState();
            verifier.setLegacyTableQueries(this.legacyTableQueries);
            verifier.verify();
            if (!verifier.hasErrors()) continue;
            errors.addAll(verifier.getErrors());
        }
        return errors;
    }

    public void setLegacyTableQueries(LegacyTableQueries legacyTableQueries) {
        this.legacyTableQueries = legacyTableQueries;
    }
}

