/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

public class GroupMapper
extends GenericLegacyImporter
implements LegacyImporter {
    public static final String REMOTE_GROUP_XML_ROOT = "groups";
    public static final String REMOTE_GROUP_XML_PRINCIPAL_DIRECTORY_ID = "directoryId";
    public static final String REMOTE_GROUP_XML_DIRECTORY_ID = "directoryId";
    public static final String REMOTE_GROUP_XML_DESCRIPTION = "description";
    public static final String REMOTE_GROUP_XML_PRINCIPAL_NODE = "principals";
    public static final String REMOTE_GROUP_XML_PRINCIPAL = "principal";
    private final GroupDAOHibernate groupDAO;
    private final MembershipDAOHibernate membershipDAO;
    private final DirectoryDAOHibernate directoryDAO;

    public GroupMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, GroupDAOHibernate groupDAO, MembershipDAOHibernate membershipDAO, DirectoryDAOHibernate directoryDAO) {
        super(sessionFactory, batchProcessor);
        this.groupDAO = groupDAO;
        this.membershipDAO = membershipDAO;
        this.directoryDAO = directoryDAO;
    }

    @Override
    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element groupsElement = (Element)root.selectSingleNode("/crowd/ groups");
        if (groupsElement == null) {
            this.logger.error((Object)"No groups were found for importing!");
            return;
        }
        ArrayList<InternalGroupWithAttributes> groups = new ArrayList<InternalGroupWithAttributes>();
        Iterator remoteGroups = groupsElement.elementIterator();
        while (remoteGroups.hasNext()) {
            Element groupElement = (Element)remoteGroups.next();
            InternalGroupWithAttributes group = this.getGroupAndAttributesFromXml(groupElement, importData.getOldToNewDirectoryIds());
            groups.add(group);
        }
        BatchResultWithIdReferences groupImportResults = this.groupDAO.addAll(groups);
        for (InternalGroupWithAttributes group : groupImportResults.getFailedEntities()) {
            this.logger.error((Object)("Unable to add group <" + group.getName() + "> in directory with id <" + group.getDirectoryId() + ">"));
        }
        if (groupImportResults.hasFailures()) {
            throw new ImportException("Unable to import all groups. See logs for more details.");
        }
        Iterator remoteGroups2 = groupsElement.elementIterator();
        while (remoteGroups2.hasNext()) {
            Element groupElement = (Element)remoteGroups2.next();
            Set<InternalMembership> memberships = this.getMemberships(groupElement, importData, (BatchResultWithIdReferences<Group>)groupImportResults);
            BatchResult membershipResult = this.membershipDAO.addAll(memberships);
            for (InternalMembership membership : membershipResult.getFailedEntities()) {
                this.logger.error((Object)("Unable to add user <" + membership.getChildName() + "> to group <" + membership.getParentName() + "> in directory with id <" + membership.getDirectory().getId() + ">"));
            }
            if (!membershipResult.hasFailures()) continue;
            throw new ImportException("Unable to import all memberships. See logs for more details.");
        }
    }

    protected InternalGroupWithAttributes getGroupAndAttributesFromXml(Element groupElement, Map<Long, Long> oldToNewDirectoryIds) {
        Long oldDirectoryId = Long.parseLong(groupElement.element("directoryId").getText());
        Long directoryId = oldToNewDirectoryIds.get(oldDirectoryId);
        if (directoryId == null) {
            throw new IllegalArgumentException("Group belongs to an unknown old directory with ID: " + directoryId);
        }
        DirectoryImpl directory = (DirectoryImpl)this.directoryDAO.loadReference(directoryId.longValue());
        InternalEntityTemplate internalEntityTemplate = this.getInternalEntityTemplateFromLegacyXml(groupElement);
        internalEntityTemplate.setName(internalEntityTemplate.getName());
        internalEntityTemplate.setId(null);
        GroupTemplate groupTemplate = new GroupTemplate(internalEntityTemplate.getName(), directory.getId().longValue(), GroupType.GROUP);
        groupTemplate.setActive(internalEntityTemplate.isActive());
        String description = "";
        Element descriptionElement = groupElement.element(REMOTE_GROUP_XML_DESCRIPTION);
        if (descriptionElement != null && descriptionElement.hasContent()) {
            description = descriptionElement.getText();
        }
        groupTemplate.setDescription(description);
        InternalGroup group = new InternalGroup(internalEntityTemplate, (Directory)directory, groupTemplate);
        Map<String, Set<String>> attributes = this.getMultiValuedAttributesMapFromXml(groupElement);
        return new InternalGroupWithAttributes(group, attributes);
    }

    protected Set<InternalMembership> getMemberships(Element groupElement, LegacyImportDataHolder importData, BatchResultWithIdReferences<Group> groupImportResults) {
        String groupName = groupElement.element("name").getText();
        Long oldDirectoryId = Long.parseLong(groupElement.element("directoryId").getText());
        Long directoryId = importData.getOldToNewDirectoryIds().get(oldDirectoryId);
        if (directoryId == null) {
            throw new IllegalArgumentException("Group belongs to an unknown old directory with ID: " + directoryId);
        }
        DirectoryImpl directory = (DirectoryImpl)this.directoryDAO.loadReference(directoryId.longValue());
        Long groupId = groupImportResults.getIdReference(directoryId, groupName);
        HashSet<InternalMembership> memberships = new HashSet<InternalMembership>();
        Element membersElement = groupElement.element(REMOTE_GROUP_XML_PRINCIPAL_NODE);
        if (membersElement != null && membersElement.hasContent()) {
            Iterator iterator = membersElement.elementIterator(REMOTE_GROUP_XML_PRINCIPAL);
            while (iterator.hasNext()) {
                Element memberElement = (Element)iterator.next();
                String memberName = memberElement.attributeValue("name");
                Long userId = importData.getUserImportResults().getIdReference(directoryId, memberName);
                InternalMembership membership = new InternalMembership(null, groupId, userId, MembershipType.GROUP_USER, GroupType.GROUP, groupName, memberName, directory);
                memberships.add(membership);
            }
        }
        return memberships;
    }
}

