/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import com.atlassian.crowd.migration.legacy.XmlMapper;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupAttribute;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMapper
extends XmlMapper
implements Mapper {
    private final InternalGroupDao groupDao;
    private final DirectoryDAOHibernate directoryDao;
    protected static final String GROUP_XML_ROOT = "groups";
    private static final String GROUP_XML_NODE = "group";
    private static final String GROUP_XML_DIRECTORY_ID = "directoryId";
    private static final String GROUP_XML_DESCRIPTION = "description";
    private static final String GROUP_XML_TYPE = "type";
    private static final String GROUP_XML_ATTRIBUTES = "attributes";
    private static final String GROUP_XML_ATTRIBUTE = "attribute";
    private static final String GROUP_XML_ATTRIBUTE_NAME = "name";
    private static final String GROUP_XML_ATTRIBUTE_VALUE = "value";
    public static final String REMOTE_GROUP_XML_ROOT = "groups";
    public static final String REMOTE_GROUP_XML_NODE = "group";
    public static final String REMOTE_GROUP_XML_PRINCIPAL_NAME = "name";
    public static final String REMOTE_GROUP_XML_NAME = "name";
    public static final String REMOTE_GROUP_XML_PRINCIPAL_DIRECTORY_ID = "directoryId";
    public static final String REMOTE_GROUP_XML_DIRECTORY_ID = "directoryId";
    public static final String REMOTE_GROUP_XML_ACTIVE = "active";
    public static final String REMOTE_GROUP_XML_DESCRIPTION = "description";
    public static final String REMOTE_GROUP_XML_PRINCIPAL_NODE = "principals";
    public static final String REMOTE_GROUP_XML_PRINCIPAL = "principal";

    public GroupMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, GroupDAOHibernate groupDao, DirectoryDAOHibernate directoryDao) {
        super(sessionFactory, batchProcessor);
        this.groupDao = groupDao;
        this.directoryDao = directoryDao;
    }

    @Override
    public Element exportXml(Map options) throws ExportException {
        Element groupRoot = DocumentHelper.createElement((String)"groups");
        List<Directory> directories = this.findAllExportableDirectories();
        for (Directory directory : directories) {
            List groups = this.groupDao.search(directory.getId().longValue(), QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1));
            for (InternalGroup group : groups) {
                Set attributes = this.groupDao.findGroupAttributes(group.getId().longValue());
                this.addGroupToXml(group, attributes, groupRoot);
            }
        }
        return groupRoot;
    }

    protected void addGroupToXml(InternalGroup group, Set<InternalGroupAttribute> attributes, Element groupRoot) {
        Element groupElement = groupRoot.addElement("group");
        groupElement.addElement("directoryId").addText(String.valueOf(group.getDirectoryId()));
        this.exportInternalEntity((InternalEntity)group, groupElement);
        groupElement.addElement("description").addText(StringUtils.defaultString((String)group.getDescription()));
        groupElement.addElement(GROUP_XML_TYPE).addText(group.getType().name());
        this.addGroupAttributesToXml(attributes, groupElement);
    }

    private void addGroupAttributesToXml(Set<InternalGroupAttribute> attributes, Element groupElement) {
        Element attributesElement = groupElement.addElement(GROUP_XML_ATTRIBUTES);
        for (InternalGroupAttribute attribute : attributes) {
            Element attributeElement = attributesElement.addElement(GROUP_XML_ATTRIBUTE);
            attributeElement.addElement("id").addText(attribute.getId().toString());
            attributeElement.addElement("name").addText(attribute.getName());
            attributeElement.addElement(GROUP_XML_ATTRIBUTE_VALUE).addText(attribute.getValue());
        }
    }

    @Override
    public void importXml(Element root) throws ImportException {
        Element groupsElement = (Element)root.selectSingleNode("/crowd/ groups");
        if (groupsElement == null) {
            this.logger.error((Object)"No groups were found for importing!");
            return;
        }
        ArrayList<InternalGroup> groupsToReplicate = new ArrayList<InternalGroup>();
        ArrayList<InternalGroupAttribute> groupAttributesToReplicate = new ArrayList<InternalGroupAttribute>();
        Iterator groupElementIterator = groupsElement.elementIterator();
        while (groupElementIterator.hasNext()) {
            Element groupElement = (Element)groupElementIterator.next();
            InternalGroup group = this.getGroupFromXml(groupElement);
            if (FULL_BACKUP_DIRECTORY_TYPES.contains(group.getDirectory().getType())) {
                groupsToReplicate.add(group);
            }
            Set<InternalGroupAttribute> attributes = this.getGroupAttributesFromXml(groupElement, group);
            groupAttributesToReplicate.addAll(attributes);
        }
        this.logger.info((Object)("About to replicate " + groupsToReplicate.size() + " groups"));
        this.addEntities(groupsToReplicate);
        this.logger.info((Object)"Group replication complete");
        this.logger.info((Object)("About to replicate " + groupAttributesToReplicate.size() + " group attributes"));
        this.addEntities(groupAttributesToReplicate);
        this.logger.info((Object)"Group attribute replication complete");
    }

    protected InternalGroup getGroupFromXml(Element groupElement) {
        Long directoryId = Long.parseLong(groupElement.element("directoryId").getText());
        DirectoryImpl directory = (DirectoryImpl)this.directoryDao.loadReference(directoryId.longValue());
        InternalEntityTemplate internalEntityTemplate = this.getInternalEntityTemplateFromXml(groupElement);
        GroupType groupType = GroupType.valueOf((String)groupElement.element(GROUP_XML_TYPE).getText());
        GroupTemplate groupTemplate = new GroupTemplate(internalEntityTemplate.getName(), directoryId.longValue(), groupType);
        groupTemplate.setActive(internalEntityTemplate.isActive());
        groupTemplate.setDescription(groupElement.element("description").getText());
        return new InternalGroup(internalEntityTemplate, (Directory)directory, groupTemplate);
    }

    protected Set<InternalGroupAttribute> getGroupAttributesFromXml(Element groupElement, InternalGroup groupReference) {
        HashSet<InternalGroupAttribute> attributes = new HashSet<InternalGroupAttribute>();
        Element attributesElement = groupElement.element(GROUP_XML_ATTRIBUTES);
        Iterator attribsIterator = attributesElement.elementIterator();
        while (attribsIterator.hasNext()) {
            Element attributeElement = (Element)attribsIterator.next();
            Long id = Long.parseLong(attributeElement.element("id").getText());
            String name = attributeElement.element("name").getText();
            String value = attributeElement.element(GROUP_XML_ATTRIBUTE_VALUE).getText();
            InternalGroupAttribute attribute = new InternalGroupAttribute(id, groupReference, name, value);
            attributes.add(attribute);
        }
        return attributes;
    }
}

